package com.example.rezevirajmasa.demo.service.impl;

import com.example.rezevirajmasa.demo.model.Menu;
import com.example.rezevirajmasa.demo.model.PriceHistory;
import com.example.rezevirajmasa.demo.model.Restaurant;
import com.example.rezevirajmasa.demo.repository.MenuRepository;
import com.example.rezevirajmasa.demo.repository.PriceHistoryRepository;
import com.example.rezevirajmasa.demo.service.MenuService;
import com.example.rezevirajmasa.demo.service.RestaurantService;
import org.openqa.selenium.InvalidArgumentException;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Service
public class MenuServiceImpl implements MenuService {
    private final MenuRepository menuRepository;
    private final RestaurantService restaurantService;

    private final PriceHistoryRepository priceHistoryRepository;

    public MenuServiceImpl(MenuRepository menuRepository, RestaurantService restaurantService, PriceHistoryRepository priceHistoryRepository) {
        this.menuRepository = menuRepository;
        this.restaurantService = restaurantService;
        this.priceHistoryRepository = priceHistoryRepository;
    }

    @Override
    public List<Menu> getMenuByRestaurantId(Long restaurantId) {
        Restaurant restaurant = restaurantService.findByIdRestaurant(restaurantId);
        return menuRepository.findAllByRestaurant(restaurant);
    }

    @Override
    public void updateMenuPrice(Long menuId, BigDecimal newPrice) {
        Menu menu = menuRepository.findById(menuId)
                .orElseThrow(() -> new IllegalArgumentException("Menu not found"));

        if (menu.getPrice() != null && !menu.getPrice().equals(newPrice)) {
            PriceHistory priceHistory = new PriceHistory(menu, menu.getPrice(), LocalDateTime.now());
            priceHistoryRepository.save(priceHistory);
        }

        menu.setPrice(newPrice);
        menuRepository.save(menu);
    }

    @Override
    public Menu getMenuById(Long id) {
        return menuRepository.findById(id)
                .orElseThrow(()->new InvalidArgumentException("Invalid id sent: " + id));
    }
}
