import React from 'react';

const StarRating = ({ rating }) => {
    const normalizedRating = Math.min(Math.max(0, rating), 5);
    const filledStars = Math.floor(normalizedRating);
    const hasHalfStar = normalizedRating - filledStars >= 0.5;

    return (
        <div>
            {[...Array(filledStars)].map((_, index) => (
                <span key={`filled-${index}`} className="star">&#9733;</span>
            ))}

            {hasHalfStar && <span className="star half">&#9733;</span>}

            {[...Array(5 - filledStars - (hasHalfStar ? 1 : 0))].map((_, index) => (
                <span key={`empty-${index}`} className="star">&#9734;</span>
            ))}
        </div>
    );
};

export default StarRating;

