package com.example.rezevirajmasa.demo.model;

import com.example.rezevirajmasa.demo.dto.PreorderedItemDto;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import jakarta.persistence.*;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;

@Entity
@Table(name = "reservations")
@Data
public class Reservation {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "ReservationID")
    private Long reservationID;

    @ManyToOne
    @JoinColumn(name = "UserID")
    @JsonBackReference(value = "user-reservations")
    private User user;

    @ManyToOne
    @JoinColumn(name = "TableNumber", nullable = false)
    @JsonBackReference
    private TableEntity table;

    @ManyToOne
    @JoinColumn(name = "RestaurantID", nullable = false)
    private Restaurant restaurant;

    @Column(name = "ReservationDateTime", nullable = false)
    private LocalDateTime reservationDateTime;

    @Column(name = "PartySize")
    private int partySize;

    @Column(name = "SpecialRequests")
    private String specialRequests;

    @Column(name = "Status", length = 20, nullable = false)
    private String reservationStatus;

    @Column(name = "CheckInTime")
    private LocalDateTime checkInTime;

    @Getter
    @Column(name = "CheckOutTime")
    private LocalDateTime checkOutTime;

    @OneToMany(mappedBy = "reservation", cascade = CascadeType.ALL, orphanRemoval = true, fetch = FetchType.LAZY)
    private List<PreorderedItem> preOrderedItems = new ArrayList<>();

    @Column(name = "PaymentStatus", length = 20, nullable = false, columnDefinition = "VARCHAR default 'Unpaid'")
    private String paymentStatus;

    public Reservation() {

    }

    @PrePersist
    private void prePersist() {
        if (reservationStatus == null) {
            reservationStatus = "Pending";
        }
        if (paymentStatus == null) {
            paymentStatus = "Unpaid";
        }
    }

    public Reservation(User user, TableEntity table, Restaurant restaurant, LocalDateTime reservationDateTime, int partySize, String specialRequests, String status, LocalDateTime checkInTime, LocalDateTime checkOutTime, String paymentStatus) {
        this.table = table;
        this.user = user;
        this.restaurant = restaurant;
        this.reservationDateTime = reservationDateTime;
        this.partySize = partySize;
        this.specialRequests = specialRequests;
        this.reservationStatus = status;
        this.checkInTime = checkInTime;
        this.checkOutTime = checkOutTime;
        this.paymentStatus = paymentStatus;
    }


    @Override
    public String toString() {
        return "Reservation{" +
                "reservationID=" + reservationID +
                ", customer=" + user +
                ", table=" + table +
                ", restaurant=" + restaurant +
                ", reservationDateTime=" + reservationDateTime +
                ", partySize=" + partySize +
                ", specialRequests='" + specialRequests + '\'' +
                ", status='" + reservationStatus + '\'' +
                ", checkInTime=" + checkInTime +
                ", checkOutTime=" + checkOutTime +
                ", paymentStatus='" + paymentStatus + '\'' +
                '}';
    }
}