import React from "react";
import axios from "axios";
import WelcomeContent from "./WelcomeContent";
import AuthContent from "./AuthContent";
import LoginForm from "./LoginForm";
import AuthForm from "./AuthForm";
import Buttons from './Buttons';
import restaurants from "./Restaurants";

class AppContent extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            componentToShow: "welcome",
            isAuthenticated: false,
            user: null,
            loading: false
        };
    }

    componentDidMount() {
        const token = localStorage.getItem('token');
        console.log(token);
        if (token) {
            this.setAuthToken(token);
            this.setState({ componentToShow: "restaurants", isAuthenticated: true });
        }
    }

    fetchUserDetails = (token) => {
        console.log("Fetching User Details...");
        axios.get("/api/user")
            .then((response) => {
                this.setState({
                    user: response.data,
                    componentToShow: "restaurants",
                    isAuthenticated: true
                });
            })
            .catch((error) => {
                console.error("Failed to fetch user details:", error);
            });
    };

    login = () => {
        this.setState({ componentToShow: "login" });
    }

    logout = () => {
        localStorage.removeItem('token');
        this.setAuthToken(null);
        this.setState({ componentToShow: "welcome", isAuthenticated: false });
    }

    onLogin = (e, email, password) => {
        e.preventDefault();

        axios.post("/api/login", { email, password })
            .then((response) => {
                const token = response.data.token;
                localStorage.setItem('token', token);
                console.log("Login Token:", token);
                this.setAuthToken(token);
                this.fetchUserDetails(token);
            })
            .catch((error) => {
                console.error("Login failed:", error);
                this.setState({ componentToShow: "welcome" });
            });
    };

    onRegister = (e, firstName, lastName, email, password) => {
        e.preventDefault();
        axios.post("/api/register", { firstName, lastName, email, password })
            .then((response) => {
                const token = response.data.token;
                localStorage.setItem('token', token);
                console.log(token);
                this.setAuthToken(token);
                this.fetchUserDetails(token);
            })
            .catch((error) => {
                this.setState({ componentToShow: "welcome" });
                console.error(error);
            });
    };

    setAuthToken = (token) => {
        if (token) {
            axios.defaults.headers.common["Authorization"] = `Bearer ${token}`;
        } else {
            delete axios.defaults.headers.common["Authorization"];
        }
    };

    render() {
        if (this.state.isAuthenticated) {
            return (
                <div>
                    <Buttons login={this.login} logout={this.logout} />
                    <AuthContent />
                </div>
            );
        }

        return (
            <div>
                <Buttons login={this.login} logout={this.logout} />
                {this.state.componentToShow === "welcome" && <WelcomeContent />}
                {this.state.componentToShow === "login" && <LoginForm onLogin={this.onLogin} onRegister={this.onRegister} />}
            </div>
        );
        // return (
        //     <div>
        //         <Buttons login={this.login} logout={this.logout} />
        //         {this.state.componentToShow === "welcome" && <WelcomeContent />}
        //         {this.state.componentToShow === "restaurants" && <AuthContent />}
        //         {this.state.componentToShow === "login" && <LoginForm onLogin={this.onLogin} onRegister={this.onRegister} />}
        //         {this.state.loading && <div>Loading...</div>} {/* Show loading state */}
        //     </div>
        // );
    }
}


export default AppContent;
