import React, {useEffect, useState} from 'react';
import { Link, useNavigate } from 'react-router-dom';
import {jwtDecode} from "jwt-decode";
import axios from "axios";

const Header = () => {
    const navigate = useNavigate();
    const [user, setUser] = useState({});
    const isLoggedIn = localStorage.getItem('token');

    const handleLogout = () => {
        localStorage.removeItem("token");
        localStorage.removeItem("user");
        setUser(null);
        navigate("/login");

    };

    useEffect(() => {
        const fetchUser = async () => {
            try {
                const token = localStorage.getItem("token");
                if (!token) return;

                const storedUser = localStorage.getItem("user");
                if (storedUser) {
                    setUser(JSON.parse(storedUser));
                    return;
                }

                const decodedToken = jwtDecode(token);
                const userId = decodedToken.iss;

                const { data } = await axios.get(`http://localhost:8081/api/user/${userId}`);
                setUser(data);
                localStorage.setItem("user", JSON.stringify(data));
            } catch (error) {
                console.error("Error fetching user:", error);
            }
        };
        fetchUser();
    }, [isLoggedIn]);

    return (
        <header className="header navbar navbar-expand-lg navbar-light bg-light">
            <div className="container">
                <button className="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                    <span className="navbar-toggler-icon"></span>
                </button>
                <div className="collapse navbar-collapse" id="navbarNav">
                    <ul className="navbar-nav ml-auto">
                        <li className="nav-item">
                            <Link className="nav-link" to="/">Home</Link>
                        </li>
                        <li className="nav-item">
                            <Link className="nav-link" to="/restaurants">Restaurants</Link>
                        </li>
                        <li className="nav-item">
                            <Link className="nav-link" to="/reservations">Reservations</Link>
                        </li>
                        <li className="nav-item">
                            <Link className="nav-link" to="/reservations-past">Reservation history</Link>
                        </li>
                        <form className="form-inline mt-2 mt-md-0 ml-3">
                            {isLoggedIn ? (
                                <button className="btn btn-outline-danger ml-3" onClick={handleLogout}>
                                    Logout {user?.firstName}
                                </button>
                            ) : (
                                <Link className="btn btn-outline-info ml-3" to="/login">Login</Link>
                            )}
                        </form>
                    </ul>
                </div>
            </div>
        </header>
    );
}

export default Header;