import React from 'react';

const TimeSlotList = ({ timeSlots }) => {
    return (
        <div>
            <h3>Available Time Slots</h3>
            {timeSlots.length > 0 ? (
                <ul>
                    {timeSlots.map((slot, index) => (
                        <li key={index}>{slot}</li>
                    ))}
                </ul>
            ) : (
                <p>No available time slots.</p>
            )}
        </div>
    );
};

export default TimeSlotList;
