package com.example.rezevirajmasa.demo.dto;

import com.example.rezevirajmasa.demo.model.PreorderedItem;
import com.example.rezevirajmasa.demo.model.Reservation;
import com.example.rezevirajmasa.demo.model.Restaurant;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;

@Setter
public class ReservationDTO {
    private Long reservationID;
    private String userEmail;
    private BigDecimal rating;
    private Long tableNumber;
    private LocalDateTime reservationDateTime;
    private LocalDateTime checkInTime;
    private Long restaurantId;
    private int partySize;
    private String reservationStatus;
    private String specialRequests;
    private String paymentStatus;
    private List<PreorderedItemDto> preOrderedItems;

    public ReservationDTO() {
    }

    public ReservationDTO(Long reservationID, String userEmail, BigDecimal rating, Long tableNumber,
                          LocalDateTime reservationDateTime, LocalDateTime checkInTime, Long restaurantId,
                          int partySize, String reservationStatus, String specialRequests,
                          String paymentStatus, List<PreorderedItemDto> preOrderedItems) {
        this.reservationID = reservationID;
        this.userEmail = userEmail;
        this.rating = rating;
        this.tableNumber = tableNumber;
        this.reservationDateTime = reservationDateTime;
        this.checkInTime = checkInTime;
        this.restaurantId = restaurantId;
        this.partySize = partySize;
        this.reservationStatus = reservationStatus;
        this.specialRequests = specialRequests;
        this.paymentStatus = paymentStatus;
        this.preOrderedItems = preOrderedItems;
    }

    public ReservationDTO(Reservation reservation) {
        this.reservationID = reservation.getReservationID();
        this.userEmail = reservation.getUser().getEmail();
        this.rating = reservation.getRestaurant().getRating();
        this.tableNumber = reservation.getTable().getId();
        this.reservationDateTime = reservation.getReservationDateTime();
        this.checkInTime = reservation.getCheckInTime();
        this.restaurantId = reservation.getRestaurant().getRestaurantId();
        this.partySize = reservation.getPartySize();
        this.reservationStatus = reservation.getReservationStatus();
        this.specialRequests = reservation.getSpecialRequests();
        this.paymentStatus = reservation.getPaymentStatus();

        this.preOrderedItems = reservation.getPreOrderedItems().stream()
                .map(preorderedItem -> new PreorderedItemDto(
                        preorderedItem.getPreorderedItemName(),
                        preorderedItem.getQuantity(),
                        preorderedItem.getPrice(),
                        preorderedItem.getMenu().getMenuID()))
                .collect(Collectors.toList());
    }

    public Long getReservationID() {
        return reservationID;
    }

    public String getUserEmail() {
        return userEmail;
    }

    public BigDecimal getRating() {
        return rating;
    }

    public Long getTableNumber() {
        return tableNumber;
    }

    public LocalDateTime getReservationDateTime() {
        return reservationDateTime;
    }

    public LocalDateTime getCheckInTime() {
        return checkInTime;
    }

    public Long getRestaurantId() {
        return restaurantId;
    }

    public int getPartySize() {
        return partySize;
    }

    public String getStatus() {
        return reservationStatus;
    }

    public String getSpecialRequests() {
        return specialRequests;
    }

    public String getPaymentStatus() {
        return paymentStatus;
    }

    public List<PreorderedItemDto> getPreOrderedItems() {
        return preOrderedItems;
    }

}
