package com.example.rezevirajmasa.demo.model;

import jakarta.persistence.*;
import lombok.Data;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Entity
@Table(name = "price_history")
@Data
public class PriceHistory {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "price_history_id")
    private Long priceHistoryID;

    @ManyToOne
    @JoinColumn(name = "menu_id", nullable = false)
    private Menu menu;

    @Column(name = "old_price", precision = 8, scale = 2, nullable = false)
    private BigDecimal oldPrice;

    @Column(name = "change_date", nullable = false)
    private LocalDateTime changeDate;

    public PriceHistory() {}

    public PriceHistory(Menu menu, BigDecimal oldPrice, LocalDateTime changeDate) {
        this.menu = menu;
        this.oldPrice = oldPrice;
        this.changeDate = changeDate;
    }
}
