@if ($paginator->hasPages())


    <nav aria-label="...">
        <ul class="pagination justify-content-center">

        @if ($paginator->onFirstPage())
                <li class="page-item disabled"><a class="page-link" href="{{ \Request::url() }}" rel="prev" aria-label="@lang('pagination.first')">&laquo;</a>
                </li>
            <li class="page-item disabled"><a class="page-link" href="#">Previous <span class="sr-only"></span></a></li>
        @else
                <li class="page-item"><a class="page-link" href="{{ \Request::url() }}" rel="prev" aria-label="@lang('pagination.first')">&laquo;</a>
                </li>
            <li class="page-item"><a class="page-link" href="{{ $paginator->previousPageUrl() }}" rel="prev">Previous</a></li>
        @endif

        @foreach ($elements as $element)

            @if (is_string($element))
                <li class="page-item-test disabled"><span>{{ $element }}</span></li>
            @endif

            @if (is_array($element))
                @foreach ($element as $page => $url)
                    @if ($page == $paginator->currentPage())
                        <li class="page-item active"><a class="page-link" href="#">{{ $page }} <span class="sr-only"></span></a></li>
                    @else
                        <li class="page-item-test"><a class="page-link" href="{{ $url }}">{{ $page }}</a></li>
                    @endif
                @endforeach
            @endif
        @endforeach

        @if ($paginator->hasMorePages())
            <li><a class="page-link" href="{{ $paginator->nextPageUrl() }}" rel="next">Next</a></li>
                <li class="page-item">
                    <a class="page-link" href="{{ \Request::url().'?page='.$paginator->lastPage() }}" rel="last" aria-label="@lang('pagination.last')">&raquo;</a>
                </li>
        @else
            <li class="page-item disabled"><a class="page-link" href="#">Next <span class="sr-only"></span></a></li>
                <li class="page-item disabled">
                    <a class="page-link" href="{{ \Request::url().'?page='.$paginator->lastPage() }}" rel="last" aria-label="@lang('pagination.last')">&raquo;</a>
                </li>
            @endif
    </ul>
    </nav>
@endif
