@extends('layouts.app')

@section("title", "SaveSpace - Dashboard")

@section('head')

    <!-- DataTable -->
    <link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
@endsection

@section('content')

    <div class="page-header">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="{{ url('/') }}">Dashboard</a>
                </li>
            </ol>
        </nav>
    </div>

    <div class="row">
        <div class="col-md-12">

            <div class="row">
                <div class="col-lg-4 col-md-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between mb-3">
                                <div>
                                    <p class="text-muted">Total Departments</p>
                                    <h2 class="font-weight-bold">{{ $departments->count() }}</h2>
                                </div>
                                <div>
                                    <figure class="avatar">
                                        <span class="avatar-title bg-success-bright text-success rounded-circle">
                                            <i class="ti-layout-grid2"></i>
                                        </span>
                                    </figure>
                                </div>
                            </div>
                            <div class="d-inline-flex align-items-center">
                                <a href="{{ route("dashboard.departments.index") }}" class="text-linkedin"><i class="fa fa-arrow-right text-linkedin pr-1" aria-hidden="true"></i> Show departments</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between mb-3">
                                <div>
                                    <p class="text-muted">Number of folders</p>
                                    <h2 class="font-weight-bold">{{ $folders->count() }}</h2>
                                </div>
                                <div>
                                    <figure class="avatar">
                                        <span class="avatar-title bg-info-bright text-info rounded-circle">
                                            <i class="ti-folder"></i>
                                        </span>
                                    </figure>
                                </div>
                            </div>
                            <div class="d-inline-flex align-items-center">
                                <a href="{{ route("dashboard.folders.index") }}" class="text-linkedin"><i class="fa fa-arrow-right text-linkedin pr-1" aria-hidden="true"></i> Show folders</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between mb-3">
                                <div>
                                    <p class="text-muted">Total Files</p>
                                    <h2 class="font-weight-bold">{{ $files->count() }}</h2>
                                </div>
                                <div>
                                    <figure class="avatar">
                                        <span class="avatar-title bg-warning-bright text-warning rounded-circle">
                                            <i class="ti-files"></i>
                                        </span>
                                    </figure>
                                </div>
                            </div>
                            <div class="d-inline-flex align-items-center">
                                <a href="{{ route("dashboard.files.index") }}" class="text-linkedin"><i class="fa fa-arrow-right text-linkedin pr-1" aria-hidden="true"></i> Show files</a>
                            </div>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </div>


    <div class="card">
        <div class="card-body">
            <div class="d-flex justify-content-between">
                <h6 class="card-title">Recent Files</h6>
                <div>
                    <a href="{{route("dashboard.index")}}" class="btn btn-outline-light btn-sm mr-2">
                        <i class="fa fa-refresh"></i>
                    </a>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive">
                        <table id="recent-orders" class="table table-lg">
                            <thead>
                            <tr>
                                <th>
                                </th>
                                <th>Image</th>
                                <th>Name</th>
                                <th>Created at</th>
                                <th>Updated at</th>
                                <th>Folder name</th>
                                <th>Folder archive ID</th>
                                <th>Directory</th>
                                <th>Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($recentFiles as $file)
                                <tr>
                                    <td></td>
                                    <td>
                                        @if(in_array(explode('.', $file->name)[1], $excelExt))
                                            <div class="col-xl-1 col-lg-1 col-md-1 col-sm-2">
                                                <i class="fa fa-file-excel-o text-success fa-2x"></i>
                                            </div>
                                        @else @if(in_array(explode('.', $file->name)[1], $textExt))
                                            <div class="col-xl-1 col-lg-1 col-md-1 col-sm-2">
                                                <i class="fa fa-file-word-o text-info fa-2x"></i>
                                            </div>
                                        @else @if(explode('.', $file->name)[1] == 'pdf')
                                                <div class="col-xl-1 col-lg-1 col-md-1 col-sm-2">
                                                    <i class="fa fa-file-pdf-o text-danger fa-2x"></i>
                                                </div>
                                            @else @if(in_array(explode('.', $file->name)[1], $imageExt))
                                                    <div class="col-xl-1 col-lg-1 col-md-1 col-sm-2">
                                                        <a href="{{ url('/uploads/' . $file->location) }}" class="image-popup-gallery-item">
                                                            <div class="image-hover">
                                                                <img src="{{ url('/uploads/' . $file->location) }}" class="rounded" width="30" alt="image">
                                                            </div>
                                                        </a>
                                                    </div>
                                                @else
                                                    <div class="col-xl-1 col-lg-1 col-md-1 col-sm-2">
                                                        <i class="fa fa-file-text-o text-warning fa-2x"></i>
                                                    </div>
                                                @endif
                                            @endif
                                        @endif
                                        @endif
                                    </td>
                                    <td>{{ $file->name }}</td>
                                    <td>{{ date('d.m.Y - H:i', strtotime($file->created_at)) }}</td>
                                    @if($file->updated_at==NULL)
                                        <td>/</td>
                                    @else
                                        <td>{{ date('d.m.Y - H:i', strtotime($file->updated_at)) }}</td>
                                    @endif
                                    <td><a href="{{ route('dashboard.folders.files', ['id' => $file->folder_id]) }}" class="text-linkedin">{{ \App\Models\Folder::find($file->folder_id)->name }}</a></td>
                                    <td>{{ \App\Models\Folder::find($file->folder_id)->arch_id }}</td>
                                    <!-- Trigger -->
                                    <td><button data-clipboard-text="{{$file->location}}" class="btn btn-sm btn-primary text-white" data-toggle="tooltip" data-placement="right" title="{{$file->location}}"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-clipboard" viewBox="0 0 16 16">
                                                <path d="M4 1.5H3a2 2 0 0 0-2 2V14a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V3.5a2 2 0 0 0-2-2h-1v1h1a1 1 0 0 1 1 1V14a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V3.5a1 1 0 0 1 1-1h1v-1z"/>
                                                <path d="M9.5 1a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5h-3a.5.5 0 0 1-.5-.5v-1a.5.5 0 0 1 .5-.5h3zm-3-1A1.5 1.5 0 0 0 5 1.5v1A1.5 1.5 0 0 0 6.5 4h3A1.5 1.5 0 0 0 11 2.5v-1A1.5 1.5 0 0 0 9.5 0h-3z"/>
                                            </svg></button>
                                    </td>
                                    @if(auth()->user()->hasPermission('manage_all_files'))
                                    <td>
                                        <a href="javascript:void(0)" class="text-secondary" data-toggle="modal" data-target="#editModal_{{$file->id}}" title="Edit">
                                            <i class="ti-pencil"></i>
                                        </a>
                                        <a href="{{ route("dashboard.files.downloadFile", ['id' => $file->id]) }}" class="text-danger ml-2"title="Download">
                                            <i class="ti-download"></i>
                                        </a>
                                        <a href="javascript:void(0)" class="text-danger ml-2" data-toggle="modal" data-target="#deleteModal_{{$file->id}}" title="Delete">
                                            <i class="ti-trash"></i>
                                        </a>
                                    </td>
                                    @else
                                        <td></td>
                                        @endif
                                </tr>
                                <div class="modal fade" id="deleteModal_{{$file->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalCenterTitle">Delete confirmation</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <i class="ti-close"></i>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                <form action="{{ route("dashboard.files.deleteFile", $file->id) }}" method="POST">
                                                    @csrf
                                                    @method('DELETE')
                                                    <p>Are you sure you want to delete file {{$file->name}}?</p>
                                                    <p>Location: <span class="pr-1">{{$file->location}}</span></p>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close
                                                        </button>
                                                        <button type="submit" class="btn btn-primary">Save changes</button>
                                                    </div>
                                                </form>
                                            </div>

                                        </div>
                                    </div>
                                </div>

                                <div class="modal fade" id="editModal_{{$file->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalCenterTitle">Rename file</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <i class="ti-close"></i>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                <form action="{{ route("dashboard.files.renameFile", ["id" =>$file->id]) }}" method="post" accept-charset="utf-8">
                                                    @method("patch")
                                                    @csrf
                                                    <div class="row">
                                                        <div class="col-md-12">
                                                            <div class="form-group">
                                                                <label class="form-label">Current name: {{$file->name}}</label>
                                                                <input type="text" name="name" value="{{ explode('.', $file->name)[0] }}" maxlength="255" title="Don't include: '\/.|'" pattern="^[^.\/|]+$" class="form-control" required>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <br/>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close
                                                        </button>
                                                        <button type="submit" class="btn btn-primary">Save changes</button>
                                                    </div>
                                                </form>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8 col-md-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-md-flex mb-2 mb-sm-0 justify-content-between">
                        <canvas id="canvas"></canvas>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-4 col-md-12">
            <div class="card">
                <div class="card-body pb-0">
                    <div class="d-flex justify-content-between align-items-start mb-3">
                        <h6 class="card-title mb-0">Largest departments</h6>
                        <a href="{{route("dashboard.departments.index")}}" class="small text-linkedin">View</a>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table table-striped mb-0">
                        <thead>
                        <tr>
                            <th>Department</th>
                            <th>Number of folders</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($largestDepartments as $department)
                        <tr>

                            <td>
                                <a href="#">{{$department->name}}</a>
                            </td>
                            <td>
                                <a href="#">{{$department->no_of_folders}}</a>
                            </td>
                        </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')

    <!-- Apex chart -->
    <script src="https://apexcharts.com/samples/assets/irregular-data-series.js"></script>
    <script src="{{ url('/vendors/charts/apex/apexcharts.min.js') }}"></script>

    <!-- Daterangepicker -->
    <script src="{{ url('vendors/datepicker/daterangepicker.js') }}"></script>

    <!-- DataTable -->
    <script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>

    <!-- Dashboard scripts -->
    <script src="{{ url('/assets/js/examples/dashboard.js') }}"></script>

    <!-- Vamp -->
    <script src="{{ url('vendors/vmap/jquery.vmap.min.js') }}"></script>
    <script src="{{ url('vendors/vmap/maps/jquery.vmap.usa.js') }}"></script>
    <script src="{{ url('assets/js/examples/vmap.js') }}"></script>

    <!-- To use theme colors with Javascript -->
    <div class="colors">
        <div class="bg-primary"></div>
        <div class="bg-primary-bright"></div>
        <div class="bg-secondary"></div>
        <div class="bg-secondary-bright"></div>
        <div class="bg-info"></div>
        <div class="bg-info-bright"></div>
        <div class="bg-success"></div>
        <div class="bg-success-bright"></div>
        <div class="bg-danger"></div>
        <div class="bg-danger-bright"></div>
        <div class="bg-warning"></div>
        <div class="bg-warning-bright"></div>
    </div>

    <script src="{{ url('assets/js/examples/pages/ecommerce-dashboard.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.9.3/Chart.min.js"></script>
    <script>
        var year = <?php echo $year; ?>;
        var file = <?php echo $file; ?>;
        var barChartData = {
            labels: year,
            datasets: [{
                label: 'File',
                backgroundColor: "red",
                data: file
            }]
        };

        window.onload = function() {
            var ctx = document.getElementById("canvas").getContext("2d");
            window.myBar = new Chart(ctx, {
                type: 'bar',
                data: barChartData,
                options: {
                    elements: {
                        rectangle: {
                            borderWidth: 2,
                            borderColor: '#c1c1c1',
                            borderSkipped: 'bottom'
                        }
                    },
                    responsive: true,
                    title: {
                        display: true,
                        text: 'Yearly uploaded files'
                    }
                }
            });
        };
    </script>
@endsection
