<?php

namespace Database\Factories;

use App\Models\User;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;

class UserFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = User::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'name' => $this->faker->firstName(),
            'surname' => $this->faker->lastName(),
            'username' => $this->faker->userName(),
            'password' => $this->faker->password(),
            'email' => $this->faker->email(),
            'mobile_number' => $this->faker->phoneNumber(),
            'role_id' => $this->faker->numberBetween(1, 2),
            'is_online' => $this->faker->boolean,
            'is_confirmed' => $this->faker->boolean,
            'is_forgot_password' => $this->faker->boolean,
            'created_at' => Carbon::now()
        ];
    }
}
