@extends('layouts.app')

@section("title", "Users")

@section('pageTitle', 'User List')

@section('head')
    <!-- Datatable -->
    <link rel="stylesheet" href="{{ url('vendors/dataTable/dataTables.min.css') }}" type="text/css">

@endsection

@section('content')

    <div class="page-header justify-content-between">
        <nav aria-label="breadcrumb" class="d-flex align-items-start">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="{{ url('dashboard.users') }}">Users</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">User List</li>
            </ol>
        </nav>
        <div class="dropdown">
            <a href="{{ route("dashboard.users.create") }}" class="btn btn-primary text-white">
                Add user
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="user-list" class="table table-lg">
                            <thead>
                            <tr>
                                <th>
{{--                                    <div class="custom-control custom-checkbox">--}}
{{--                                        <input type="checkbox" class="custom-control-input" id="user-list-select-all">--}}
{{--                                        <label class="custom-control-label" for="user-list-select-all"></label>--}}
{{--                                    </div>--}}
                                </th>
                                <th>State</th>
                                <th>Username</th>
                                <th>Name</th>
                                <th>Email</th>
                                <th>Phone Number</th>
                                <th>Created at</th>
                                <th>Role</th>
                                <th>Status</th>
                                <th>Last seen</th>
                                <th>Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($users as $user)
                                <tr>
                                    <td></td>
                                    <td>
                                        @if($user->is_confirmed)
                                            @if ($user->is_active)
                                                <span class="badge bg-success-bright text-success">Active</span>
                                            @else
                                                <span class="badge bg-danger-bright text-danger">Blocked</span>
                                            @endif
                                        @else
                                            <span class="badge bg-warning-bright text-warning">New user</span>
                                        @endif
                                    </td>
                                    <td>
                                            @include('dashboard.partials.avatar')
                                        {{$user->username}}
                                    </td>
                                    <td>{{$user->name .' '. $user->surname}}</td>
                                    <td>{{$user->email}}</td>
                                    <td>{{$user->mobile_number}}</td>
                                    <td>{{ date('d.m.Y', strtotime($user->created_at)) }}</td>
                                    <td>{{ $user->role->name }}</td>
                                    <td>
                                        @if(Cache::has('is_online' . $user->id))
                                            <span class="text-success">Online</span>
                                        @else
                                            <span class="text-secondary">Offline</span>
                                        @endif
                                    </td>
                                    @if($user->last_seen==NULL)
                                        <td>Never logged in</td>
                                    @else
                                    <td>{{ \Carbon\Carbon::parse($user->last_seen)->diffForHumans() }}</td>
                                    @endif
                                    @if($user->hasRole("Referent") && $user->is_confirmed)
                                        <td>
                                            <a href="{{ route("dashboard.users.edit", ["id" => $user->id]) }}" class="text-secondary" data-toggle="tooltip" title="Edit">
                                                <i class="ti-pencil"></i>
                                            </a>
                                            <a href="javascript:void(0)" class="text-danger ml-2" data-action="{{ route("dashboard.users.destroy", ["id" => $user->id]) }}" data-method="delete" title="Delete">
                                                <i class="ti-trash"></i>
                                            </a>
                                        </td>
                                    @else
                                        <td>Not available</td>
                                        @endif
                                </tr>
                            @endforeach


                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('script')
 <script src="{{ url('assets/js/examples/pages/user-list.js') }}"></script>
    <!-- Datatable -->
    <script src="{{ url('vendors/dataTable/dataTables.min.js') }}"></script>
@endsection
