<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;



class PermissionsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        \DB::table('permissions')->insert([
            ["id" => "1", "name" => "view_all_users"], 			    // Create new user
            ["id" => "2", "name" => "manage_all_users"], 		    // Access all users to manage
            ["id" => "3", "name" => "manage_all_departments"], 	    // Access all departments to manage
            ["id" => "4", "name" => "manage_all_folders"], 	        // Access all folders to manage
            ["id" => "5", "name" => "view_all_departments"], 	    // Access all departments to view
            ["id" => "6", "name" => "view_all_folders"], 	        // Access all folders to view
            ["id" => "7", "name" => "view_all_files"], 	            // View all files
            ["id" => "8", "name" => "manage_all_files"], 	        // Manage all files
            ["id" => "9", "name" => "manage_file_types"], 	        // Access file types
            ["id" => "10", "name" => "export_data"], 	            // Export data
            ["id" => "11", "name" => "download_data"],	            // Download data
            ["id" => "12", "name" => "delete_data"],	            // Delete data
        ]);
    }
}
