<?php

namespace App\Http\Controllers\Dashboard;

use App\Helpers\Alert;
use App\Http\Requests\Dashboard\NewUserRequest;
use App\Http\Requests\Dashboard\UpdateUserRequest;
use App\Models\Role;
use App\Models\User;
use App\Notifications\VerifyNewEmail;
use Illuminate\Http\Request;
use App\Notifications\WelcomeUser;
use App\Http\Controllers\Controller;

class UsersController extends Controller
{
    public function index()
    {
        return view("dashboard.users.index")->with([
            "users" => User::all()
        ]);
    }

    public function create()
    {
        return view("dashboard.users.create")->with([
            "roles" => Role::all(),
        ]);
    }

    public function store(NewUserRequest $request)
    {
        $user = new User();

        $user->name = $request->name;
        $user->surname = $request->surname;
        $user->email = $request->email;
        $user->mobile_number = $request->mobile_number;
        $user->username = $request->username;
        $user->password = $user->generateTemporaryPassword();
        $user->security_code = $user->generateSecurityCode();
        $user->verify_token = $user->generateVerifyToken();

        $user->role_id = $request->userRole;

        $user->save();

        $user->notify(new WelcomeUser($user));

        Alert::flash("New user added successfully");

        return redirect()->route("dashboard.users.index");
    }

    public function editShow($id)
    {
        return view("dashboard.users.edit")->with([
            "user" => User::findOrFail($id),
            "roles" => Role::all(),
        ]);
    }

    public function edit(UpdateUserRequest $request, $id)
    {
        $user = User::findOrFail($id);
        $user->name = $request->name;
        $user->surname = $request->surname;
        $user->username = $request->username;
        $user->email = $request->email;
        $user->mobile_number = $request->mobile_number;
        $user->role_id = $request->userRole;
        if($user->isDirty('email')) {
            $user->notify(new VerifyNewEmail($user));
        }
        $user->save();

        Alert::flash("User updated successfully");

        return redirect()->route("dashboard.users.index");
    }

    public function editUserData(UpdateUserRequest $request, $id)
    {
        $user = User::findOrFail($id);
        $user->name = $request->name;
        $user->surname = $request->surname;
        $user->mobile_number = $request->mobile_number;

        $user->save();

        Alert::flash("User data updated successfully");

        return redirect()->route("dashboard.settings.index");
    }

    public function block(Request $request, $id)
    {
        $user = User::find($id);
        $user->is_active = false;
        $user->save();
        Alert::flash($user->name . " User blocked successfully");
        return redirect()->route("dashboard.users.index");
    }

    public function unblock(Request $request, $id)
    {
        $user = User::find($id);
        $user->is_active = true;
        $user->save();
        Alert::flash($user->name . " User unblocked successfully");
        return redirect()->route("dashboard.users.index");
    }

    public function destroy(Request $request, $id)
    {
        $user = User::find($id);

        $user->userProfile->delete();
        $user->delete();

        Alert::flash($user->name . " deleted successfully");

        return redirect()->route("dashboard.users.index");
    }

    public function getUserRoles()
    {
      $roles = Role::get();
      return $roles;
    }
}
