<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;

class Department extends Model
{
    use Notifiable;

    protected $table = "departments";

    protected $fillable = ["name", "code", "user_id"];

    protected $casts = [
        'created_at' => 'datetime:d-m-Y',
    ];

    public function getCreatedByName()
    {
        return User::where('id', $this->user_id)->pluck('username')->first();
    }
}
