@extends('layouts.app')

@section("title", "Departments - Create new")

@section('pageTitle', 'Create department')

@section('content')

    <div class="page-header">
        <nav aria-label="breadcrumb" class="d-flex align-items-start">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="{{ url('dashboard/departments') }}">Departments</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">New department</li>
            </ol>
        </nav>
    </div>

    <div class="row">
        <div class="col-md-12">

            <div class="row">
                <div class="col-lg-12 col-md-12">
                    <div class="tab-content" id="v-pills-tabContent">
                        <div class="tab-pane fade show active" id="v-pills-home" role="tabpanel" aria-labelledby="v-pills-home-tab">
                            <div class="card">
                                <div class="card-body">
                                    <h6 class="card-title">New department</h6>
                                    <form action="{{ route("dashboard.departments.store") }}" method="post" accept-charset="utf-8">
                                        <div class="row">
                                            @csrf
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Name</label>
                                                    <input type="text" name="name" value="{{ old('name') }}" class="form-control" placeholder="Name" required>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Code</label>
                                                    <input type="text" name="code" value="{{ old('code') }}" class="form-control" placeholder="Code" required>
                                                </div>
                                            </div>
                                        </div>
                                        <input type="submit" value="Save changes" class="submitBtn btn btn-primary pull-right m-10">
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
