<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

////////////////////
// Auth Routes
////////////////////
Route::prefix('auth')->group(function () {

    Route::get('/login', "Auth\LoginController@showLogin")->name("auth.loginShow");
    Route::post('/login', "Auth\LoginController@login")->name("auth.login");
    Route::post('/logout', "Auth\LoginController@logout")->name("auth.logout");

    Route::get('/forgot', "Auth\ForgotPasswordController@showForgotPassword")->name("auth.forgotShow");
    Route::post('/forgot', "Auth\ForgotPasswordController@forgotPassword")->name("auth.forgot");

    Route::group(['middleware' => "createPassword"], function () {
        Route::get('/create-password/{id}/{token}', "Auth\CreatePasswordController@showCreatePassword")->name("auth.create-password-show");
        Route::post('/create-password/{id}/{token}', "Auth\CreatePasswordController@createPassword")->name("auth.create-password");
    });

    Route::group(['middleware' => "checkVerifyNewEmail"], function () {
        Route::get('/verify/{id}/{token}', "Auth\VerifyNewEmailController@create")->name("auth.verifyShow");
        Route::post('/verify/{id}/{token}', "Auth\VerifyNewEmailController@verify")->name("auth.verify");
    });

});

////////////////////
// Dashboard Routes
////////////////////
Route::group(['prefix' => 'dashboard', 'middleware' => ["auth", "checkIsActive"]], function () {

    Route::get("/", "Dashboard\IndexController@index")->name("dashboard.index");

    Route::get("/settings", "Dashboard\SettingsController@settings")->name("dashboard.settings.index");
    Route::patch("/settings/personal", "Dashboard\SettingsController@updatePersonalInformation")->name("dashboard.settings.personal");
    Route::patch("/settings/username", "Dashboard\SettingsController@updateUsername")->name("dashboard.settings.username");
    Route::patch("/settings/password", "Dashboard\SettingsController@updatePassword")->name("dashboard.settings.password");
    Route::patch("/settings/email", "Dashboard\SettingsController@updateEmail")->name("dashboard.settings.email");


    // Users
    Route::group(['middleware' => 'permission:access_all_users'], function () {
        Route::get("/users", "Dashboard\UsersController@index")->name("dashboard.users.index");
        Route::patch("/users/{id}/block", "Dashboard\UsersController@block")->name("dashboard.users.block");
        Route::patch("/users/{id}/unblock", "Dashboard\UsersController@unblock")->name("dashboard.users.unblock");
        Route::delete("/users/{id}/destroy", "Dashboard\UsersController@destroy")->name("dashboard.users.destroy");
    });

    Route::group(['middleware' => 'permission:create_user'], function () {
        Route::get("/users/create", "Dashboard\UsersController@create")->name("dashboard.users.create");
        Route::post("/users/store", "Dashboard\UsersController@store")->name("dashboard.users.store");
        Route::get("/users/{id}/edit", "Dashboard\UsersController@editShow")->name("dashboard.users.editShow");
        Route::patch("/users/{id}/edit", "Dashboard\UsersController@edit")->name("dashboard.users.edit");
        Route::patch("/users/{id}/editUserData", "Dashboard\UsersController@editUserData")->name("dashboard.users.editUserData");
    });

    // Departments
    Route::group(['middleware' => 'permission:access_all_departments'], function () {
        Route::get("/departments", "Dashboard\departmentsController@index")->name("dashboard.departments.index");
        Route::get("/departments/create", "Dashboard\departmentsController@create")->name("dashboard.departments.create");
        Route::post("/departments/store", "Dashboard\departmentsController@store")->name("dashboard.departments.store");
        Route::get("/departments/{id}/edit", "Dashboard\departmentsController@editShow")->name("dashboard.departments.editShow");
        Route::patch("/departments/{id}/edit", "Dashboard\departmentsController@edit")->name("dashboard.departments.edit");
        Route::delete("/departments/{id}/destroy", "Dashboard\DepartmentsController@destroy")->name("dashboard.departments.destroy");
    });

});
