<?php

namespace App\Http\Middleware;

use App\Models\User;
use App\Services\Hashid;
use Closure;

class CheckVerifyToken
{
    /**
     * Handle an incoming request.
     *
     * @param \Illuminate\Http\Request $request
     * @param \Closure $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $hashId = new Hashid();
        $id = $request->route("id");
        $token = $request->route("token");
        $user = User::findOrFail($hashId->decode($id));

        if ($user->verify_token !== $token || now()->greaterThan($user->updated_at->addMinutes(1))) {
            return redirect()->route("auth.login");
        }

        return $next($request);
    }
}
