<?php

namespace App\Services;

use Hashids\Hashids;

class Hashid
{
    protected $hashid;

    public function __construct()
    {
        $this->hashid = new Hashids(config("app.key"), 6, "0123456789abcdefg");
    }

    public function decode($id)
    {
        return $this->hashid->decode($id)[0];
    }

    public function __call($method, $args)
    {
        if (!method_exists($this->hashid, $method)) {
            throw new \Exception("Call to undefined method '{$method}'");
        }

        return call_user_func_array([$this->hashid, $method], $args);
    }
}
