<?php

use Illuminate\Support\Str;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->increments('id')->startingValue(1);
            $table->string('name');
            $table->string('surname');
            $table->string('username')->unique();
            $table->string('email')->unique();
            $table->string('phone_number')->unique();
            $table->string('avatar')->nullable();
            $table->integer('role_id')->unsigned();
            $table->foreign("role_id")->references("id")->on("roles");
            $table->boolean('is_active')->default(false);
            $table->boolean('is_online')->default(false);
            $table->boolean('is_confirmed')->default(false);
            $table->boolean('is_forgot_password')->default(false);
            $table->integer("created_by")->unsigned();
            $table->string('security_code')->nullable();
            $table->string('verify_token')->nullable();
            $table->string('password');
            $table->rememberToken();
            $table->timestamps();

            $table->foreign("created_by")->references("id")->on("users")->onDelete("cascade")->onUpdate("cascade");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
