@extends('layouts.auth')

@section("title", "SaveSpace | Login")

@section('content')

    <!-- logo -->
    <div id="logo">
        <img class="logo" width="150" src="{{ url('assets/media/images/logo.png') }}" alt="image">
     </div>
    <!-- ./ logo -->

    <h5>Sign in</h5>

    <!-- form -->
    <form action="{{ route("auth.login") }}" method="post" accept-charset="utf-8">

        @csrf

            <div class="alert alert-error fade show" role="alert">
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                </button>
            </div>
        <div class="form-group">
            <input id="username" type="text" tabindex="1" class="form-control" value="{{ old('username') }}" name="username" placeholder="Username" autocomplete="off" required autofocus>
                <span class="invalid-feedback" role="alert">
                </span>
        </div>

        <div class="form-group">
            <input id="password" type="password" tabindex="2" class="form-control" name="password" autocomplete="off" placeholder="Password" required>
                <span class="invalid-feedback" role="alert">
                </span>
        </div>

        <div class="form-group d-flex justify-content-between">
            <label class="custom-control custom-checkbox">
                <input class="custom-control-input" type="checkbox" name="remember" id="remember" {{ old('remember') ? 'checked' : '' }}>
                <span class="custom-control-label">Remember me</span>
            </label>
            <a href="/auth/forgot">Reset password</a>
        </div>

        <input type="submit" value="Sign in" class="btn btn-primary btn-block">
        <hr>
    </form>

@endsection
