<div class="app-action">
    <div class="action-left">
        <ul class="list-inline">
            <li class="list-inline-item mb-0">
                <a href="#" class="btn btn-outline-light dropdown-toggle" data-toggle="dropdown">
                    <i data-feather="plus" class="mr-1"></i>
                    Add
                </a>
                <div class="dropdown-menu">
                    <a class="dropdown-item" href="{{route("dashboard.departments.create")}}">Department</a>
                    <a class="dropdown-item" href="{{route("dashboard.documents.create")}}">Document</a>
                </div>
            </li>
            <li class="list-inline-item mb-0">
                <a href="#" class="btn btn-outline-light dropdown-toggle" data-toggle="dropdown">Departments</a>
                <div class="dropdown-menu">
                    @foreach($departments as $department)
                        <a class="dropdown-item d-flex justify-content-between m-5" href="{{ route("dashboard.documents.getDocumentsInDepartment", ["id" => $department->id]) }}">
                            {{$department->name}}
                            <span class="text-muted">{{$department->document->count()}}</span>
                        </a>
                    @endforeach
                </div>
            </li>
            <li class="list-inline-item mb-0">
                <a href="#" class="btn btn-outline-light dropdown-toggle" data-toggle="dropdown">
                    Order by
                </a>
                <div class="dropdown-menu">
                    <a class="dropdown-item" href="#">Date</a>
                    <a class="dropdown-item" href="#">Name</a>
                    <a class="dropdown-item" href="#">Size</a>
                </div>
            </li>
        </ul>
    </div>
    <div class="action-right">
        <form class="d-flex mr-3">
            <a href="#" class="app-sidebar-menu-button btn btn-outline-light">
                <i data-feather="menu"></i>
            </a>
            <div class="input-group">
                <input type="text" class="form-control" placeholder="Search file"
                       aria-describedby="button-addon1">
                <div class="input-group-append">
                    <button class="btn btn-outline-light" type="button" id="button-addon1">
                        <i data-feather="search"></i>
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>
