<div class="col-md-3 app-sidebar">
        <div class="card">
            <div class="card-body">
                <a href="{{ route("dashboard.documents.create") }}" class="btn btn-secondary btn-block file-upload-btn text-white" data-action="{{ route("dashboard.documents.create") }}">
                    Add document
                </a>
                <form class="d-none" id="file-upload">
                    <input type="file" multiple>
                </form>
            </div>
            <div class="app-sidebar-menu">
                <div class="list-group list-group-flush">
                    <a href="{{route("dashboard.documents.index")}}" class="list-group-item d-flex align-items-center">
                        <i data-feather="folder" class="width-15 height-15 mr-2"></i>
                        Documents
                        <span class="small ml-auto">{{$totalDocs}}</span>
                    </a>
                    @foreach($departments as $department)
                        <a href="{{ route("dashboard.documents.getDocumentsInDepartment", ["id" => $department->id]) }}" class="list-group-item d-flex align-items-center">
                            <i data-feather="folder" class="width-15 height-15 mr-2"></i>
                            {{$department->name}}
                            <span class="small ml-auto">{{$department->document->count()}}</span>
                        </a>
                    @endforeach
                    <a href="" class="list-group-item">
                        <i data-feather="upload-cloud" class="width-15 height-15 mr-2"></i>
                        Recents
                    </a>
                    <a href="" class="list-group-item d-flex align-items-center">
                        <i data-feather="star" class="width-15 height-15 mr-2"></i>
                        Important
                        <span class="small ml-auto">10</span>
                    </a>
                    <a href="" class="list-group-item">
                        <i data-feather="trash" class="width-15 height-15 mr-2"></i>
                        Deleted Files
                    </a>
                </div>
                <div class="card-body">
                    <h6 class="mb-4">Storage Status</h6>
                    <div class="d-flex align-items-center">
                        <div class="mr-3">
                            <i data-feather="database" class="width-30 height-30"></i>
                        </div>
                        <div class="flex-grow-1">
                            <div class="progress" style="height: 10px">
                                <div class="progress-bar progress-bar-striped" role="progressbar"
                                     style="width: 40%" aria-valuenow="10" aria-valuemin="0"
                                     aria-valuemax="100"></div>
                            </div>
                            <div class="line-height-12 small text-muted mt-2">19.5GB used of 25GB</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
