@extends('layouts.app')

@section('pageTitle', 'File Manager')

@section('content')

    <div class="row app-block mb-4">
        @include('dashboard.documents.fragments.menu')

        <div class="col-md-9 app-content">
            <div class="app-content-overlay"></div>
            @include('dashboard.documents.fragments.filters')

            <p>Documents</p>
            <div class="row">
                @foreach($documents as $document)
                    <div class="col-xl-3 col-lg-4 col-md-6 col-sm-12">
                        <div class="card app-file-list">
                            <div class="app-file-icon">
                                <i class="fa fa-file-text-o text-primary"></i>
                                <div class="dropdown position-absolute top-0 right-0 mr-3">
                                    <a href="#" class="btn btn-outline-light btn-sm" data-toggle="dropdown">
                                        <i class="fa fa-ellipsis-h"></i>
                                    </a>
                                    <div class="dropdown-menu dropdown-menu-right">
                                        <a href="{{ route("dashboard.documents.edit", ["id" => $document->id]) }}" class="dropdown-item">View Details</a>
                                        <a href="#" class="dropdown-item">Share</a>
                                        <a href="#" class="dropdown-item">Download</a>
                                        <a href="#" class="dropdown-item">Move to</a>
                                        <a href="#" class="dropdown-item">Delete</a>
                                    </div>
                                </div>
                            </div>
                            <div class="p-2 small">
                                <div>{{$document->name}} - {{$document->arch_id}}</div>
                                <div class="text-muted">{{$document->description}}</div>
                                <div class="text-muted">1.2MB</div>
                            </div>
                        </div>
                    </div>
                @endforeach


            </div>
    </div>

@endsection

@section('script')

    <script>
        $(function () {
            $(document).on('click', '.file-upload-btn', function () {
                $('form#file-upload input[type="file"]').trigger('click');
            });

            $(document).on('click', '.app-sidebar-menu-button', function () {
                $('.app-block .app-sidebar, .app-content-overlay').addClass('show');
                // $('.app-block .app-sidebar .app-sidebar-menu').niceScroll().resize();
                return false;
            });

            $(document).on('click', '.app-content-overlay', function () {
                $('.app-block .app-sidebar, .app-content-overlay').removeClass('show');
                return false;
            });
        });
    </script>

@endsection
