@extends('layouts.app')

@section("title", "Users - Create new")

@section('pageTitle', 'Create user')

@section('content')

    <div class="page-header">
        <nav aria-label="breadcrumb" class="d-flex align-items-start">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="{{ url('dashboard/users') }}">Users</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Create user</li>
            </ol>
        </nav>
    </div>

    <div class="row">
        <div class="col-md-12">

            <div class="row">
                <div class="col-lg-12 col-md-12">
                    <div class="tab-content" id="v-pills-tabContent">
                        <div class="tab-pane fade show active" id="v-pills-home" role="tabpanel" aria-labelledby="v-pills-home-tab">
                            <div class="card">
                                <div class="card-body">
                                    <h6 class="card-title">User account data</h6>
                                    <form action="{{ route("dashboard.users.store") }}" method="post" accept-charset="utf-8" enctype='multipart/form-data'>
                                        @csrf
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Name</label>
                                                    <input type="text" name="name" value="{{ old('name') }}" class="form-control" placeholder="Name" required>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Surname</label>
                                                    <input type="text" name="surname" value="{{ old('surname') }}" class="form-control" placeholder="Surname" required>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label class="form-label">Username</label>
                                                    <input type="text" name="username" value="{{ old('username') }}" class="form-control" placeholder="Username" required>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label class="form-label">Role</label>
                                                    <select class="form-control" name="userRole">
                                                        @foreach ($roles as $role)
                                                            <option value="{{ $role->id }}" {{ (old("userRole") == $role->id ? "selected" : "" ) }}>{{ ucfirst($role->name) }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Email</label>
                                                    <input type="email" name="email" value="{{ old('email') }}" class="form-control" placeholder="E-mail" required>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label class="form-label">Mobile Number</label>
                                                    <input type="text" name="mobile_number" value="{{ old('mobile_number') }}" class="form-control" placeholder="Phone number" autocomplete="off" required>
                                                </div>
                                            </div>

                                        </div>

                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Avatar</label>
                                                    <input type="file" name="avatar" value="{{ old('avatar') }}" class="form-control" accept="image/*">
                                                </div>
                                            </div>
                                        </div>
                                            <input type="submit" value="Save changes" class="submitBtn btn btn-primary pull-right m-10">
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
