@extends('layouts.app')

@section("title", "SaveSpace - Folders")

@section('content')

    <div class="row app-block mb-4">
        <div class="col-md-3 app-sidebar">
            <div class="card">
                <div class="card-body">
                    @if(auth()->user()->hasPermission('manage_all_folders'))
                    <a href="javascript:void(0)" class="btn btn-secondary btn-block file-upload-btn text-white" data-toggle="modal" data-target="#createModal">
                        Add folder
                    </a>
                        @endif
                </div>
                <div class="app-sidebar-menu">
                    <div class="list-group list-group-flush">
                        <a href="{{route("dashboard.folders.index")}}" class="list-group-item d-flex align-items-center">
                            <i data-feather="folder" class="width-15 height-15 mr-2"></i>
                            Folders
                        </a>
                        @foreach($departments as $department)
                            @if(Request::query('id') == $department->id)
                            <a href="{{ route("dashboard.folders.index", ["id" => $department->id]) }}" class="list-group-item d-flex align-items-center" style="font-weight: bold;">
                                <i data-feather="folder" class="width-15 height-15 mr-2"></i>
                                {{$department->name}}
                                <span class="small ml-auto">{{$department->folder->count()}}</span>
                            </a>
                            @else
                                <a href="{{ route("dashboard.folders.index", ["id" => $department->id]) }}" class="list-group-item d-flex align-items-center">
                                <i data-feather="folder" class="width-15 height-15 mr-2"></i>
                                {{$department->name}}
                                <span class="small ml-auto">{{$department->folder->count()}}</span>
                            </a>
                            @endif
                        @endforeach
                        <a href="{{ URL::current()."?sort=recent" }}" class="list-group-item">
                            <i data-feather="upload-cloud" class="width-15 height-15 mr-2"></i>
                            Recents
                        </a>
                    </div>
                    <div class="card-body">
                        <h6 class="mb-4">Storage Status</h6>
                        <div class="d-flex align-items-center">
                            <div class="mr-3">
                                <i data-feather="database" class="width-30 height-30"></i>
                            </div>
                            <div class="flex-grow-1">
                                <div class="progress" style="height: 10px">
                                    <div class="progress-bar progress-bar-striped" role="progressbar"
                                         style="width: {{$diskUse}}" aria-valuenow="10" aria-valuemin="0"
                                         aria-valuemax="100"></div>
                                    <span class="sr-only">{{$diskUse}}</span>
                                </div>
                                <div class="line-height-12 small text-muted mt-2">{{round($diskUsedSize,2)}} GB /
                                    {{round($diskTotalSize,2)}} GB ({{$diskUse}})</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-9 app-content">
            <div class="app-content-overlay"></div>
            <div class="app-action">
                <div class="action-left">
                    <ul class="list-inline">
                        @if(auth()->user()->hasPermission('manage_all_folders'))
                        <li class="list-inline-item mb-0">
                            <a href="#" class="btn btn-outline-light dropdown-toggle" data-toggle="dropdown">
                                <i data-feather="plus" class="mr-1"></i>
                                Actions
                            </a>
                            <div class="dropdown-menu">
                                <a class="dropdown-item" href="javascript:void(0)" data-toggle="modal" data-target="#createModal">Add folder</a>
                                @endif
                                    @if(auth()->user()->hasPermission('export_data'))
                                <a href="{{ route('dashboard.folders.export') }}" class="dropdown-item text-success">Export</a>
                            </div>
                        </li>
                        @endif
                        <li class="list-inline-item mb-0">
                            <a href="#" class="btn btn-outline-light dropdown-toggle" data-toggle="dropdown">Departments</a>
                            <div class="dropdown-menu">
                                @foreach($departments as $department)
                                    <a class="dropdown-item d-flex justify-content-between m-5" href="{{ route("dashboard.folders.index", ["id" => $department->id]) }}">
                                        {{$department->name}}
                                        <span class="text-muted">{{$department->folder->count()}}</span>
                                    </a>
                                @endforeach
                            </div>
                        </li>
                        <li class="list-inline-item mb-0">
                            <a href="#" class="btn btn-outline-light dropdown-toggle" data-toggle="dropdown">
                                Order by
                            </a>
                            <div class="dropdown-menu">
                                @if(Request::get('id'))
                                    <a class="dropdown-item" href="{{ URL::current()."?id=".Request::get('id')."&sort=newest" }}">Date</a>
                                    <a class="dropdown-item" href="{{ URL::current()."?id=".Request::get('id')."&sort=name" }}">Name</a>
                                    <a class="dropdown-item" href="{{ URL::current()."?id=".Request::get('id')."&sort=no_of_files" }}">Number of files</a>
                                @else
                                    <a class="dropdown-item" href="{{ URL::current()."?sort=newest" }}">Date</a>
                                    <a class="dropdown-item" href="{{ URL::current()."?sort=name" }}">Name</a>
                                    <a class="dropdown-item" href="{{ URL::current()."?sort=no_of_files" }}">Number of files</a>
                                @endif
                            </div>
                        </li>
                    </ul>
                </div>
                <div class="action-right">
                    <form action="{{ route("dashboard.folders.index") }}" method="get" class="d-flex mr-3">
                        <div class="input-group">
                            <input type="text" name="search" class="form-control" placeholder="Search folder"
                                   aria-describedby="button-addon1" required>
                            <div class="input-group-append">
                                <button class="btn btn-outline-light searchSubmitBtn" type="submit" value="Search">
                                    <i data-feather="search"></i>
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            @if(!Request::query('id'))
                <h4>Folders</h4><br/>
            @else
                <h4> {{ $deptName }} - {{$deptCode}} </h4>
                <br/>
            @endif

            <div class="row">
                @forelse($folders as $folder)
                    <div class="col-xl-4 col-lg-6">
                        <div class="card">
                            <div class="card-body">
                                <i class="fa fa-folder fa-2x pr-2" aria-hidden="true"></i>
                                <span class="card-title" style="font-size: 1.5rem;">{{$folder->name}}</span>

                                <div class="d-flex align-items-center">
                                    <div class="dropdown ml-auto">
                                        <a href="#" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            <i class="fa fa-ellipsis-v" aria-hidden="true"></i>
                                        </a>
                                        <div class="dropdown-menu dropdown-menu-right">
                                            <a href="{{ route("dashboard.folders.files", ["id" => $folder->id]) }}" class="dropdown-item">View files</a>
                                            @if(auth()->user()->hasPermission('manage_all_files'))
                                                <a href="javascript:void(0)" data-toggle="modal" data-target="#uploadFiles_{{$folder->id}}" class="dropdown-item">Upload files</a>
                                            @endif
                                            @if(auth()->user()->hasPermission('download_data'))
                                            <a href="{{ route("dashboard.folders.downloadFolder", ['id' => $folder->id]) }}" class="dropdown-item">Download</a>
                                            @endif
                                            @if(auth()->user()->hasPermission('manage_all_folders'))
                                                <a href="javascript:void(0)" data-toggle="modal" data-target="#createVersionModal_{{$folder->id}}" class="dropdown-item">Create version</a>
                                            @endif
                                            @if(auth()->user()->hasPermission('delete_data'))
                                            <a href="javascript:void(0)" class="dropdown-item" data-toggle="modal" data-target="#deleteModal_{{$folder->id}}">Delete</a>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="text-muted small mt-1 mb-3">Number of files: {{$folder->files->count()}}</div>
                                <p class="badge bg-success-bright text-success">Version: {{$folder->version}}</p>
                                <p>Archive ID: {{$folder->arch_id}}</p>
                                <p>Note: {{$folder->note}}</p>
                                <div class="row">
                                    <div class="col">
                                        <div class="text-muted mb-1 small">Created</div>
                                        <div> {{ $folder->created_at->diffForHumans() }}, {{ date('d.m.Y', strtotime($folder->created_at))}}</div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer">
                                <small class="text-muted">Last updated: {{ date('d.m.Y H:i', strtotime($folder->updated_at)) }}</small>

                            </div>
                        </div>
                    </div>

                    <div class="modal fade" id="deleteModal_{{$folder->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalCenterTitle">Delete confirmation</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <i class="ti-close"></i>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="{{ route("dashboard.folders.destroy", $folder->id) }}" method="POST">
                                        @csrf
                                        @method('DELETE')
                                        <p>Are you sure you want to delete folder {{$folder->name}} with Archive ID: {{ $folder->arch_id }}?</p>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close
                                            </button>
                                            <button type="submit" class="btn btn-primary">Save changes</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="modal fade" id="uploadFiles_{{$folder->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalCenterTitle">Upload files to {{$folder->name}}</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <i class="ti-close"></i>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="{{ route("dashboard.files.store") }}" method="post" accept-charset="utf-8" enctype="multipart/form-data">
                                        @csrf
                                        <div class="row">
                                            <div class="col-md-10">
                                                <div class="form-group">
                                                        <select class="form-control" name="folder" hidden>
                                                                <option value="{{ $folder->id }}" {{ (old("folder") == $folder->id ? "selected" : "") }}>{{ $folder->name }}</option>
                                                        </select>
                                                </div>
                                            </div>
                                            <div class="col-md-10">
                                                <div class="form-group">
                                                    <label for="exampleFormControlSelect1">Files</label>


                                                    <input type="file" class="form-control" id="file-item" name="file_item[]" accept="{{ $fileTypes }}" multiple>
                                                </div>
                                            </div>
                                        </div>
                                        <br/>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close
                                            </button>
                                            <button type="submit" class="btn btn-primary">Save changes</button>
                                        </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>

                    <div class="modal fade" id="createVersionModal_{{$folder->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalCenterTitle">Create folder</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <i class="ti-close"></i>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="{{ route("dashboard.folders.store") }}" method="post" accept-charset="utf-8" enctype="multipart/form-data">
                                        @csrf
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="exampleFormControlSelect1">Department</label>
                                                        <select class="form-control" name="department" required>
                                                                <option value="{{ $folder->department->id }}">{{ $folder->department->name }}</option>
                                                        </select>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Archive ID</label>
                                                    <input type="text" name="arch_id" value="{{$folder->arch_id}}" class="form-control" placeholder="Archive ID" required>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Name</label>
                                                    <input type="text" name="name" value="{{ $folder->name }}" minlength="2" maxlength="30" class="form-control" placeholder="Name" required>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Note</label>
                                                    <textarea class="form-control" name="note" maxlength="80">{{ old('note') }}</textarea>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <input type="file" class="form-control" id="file-item" name="file_item[]" accept="{{ $fileTypes }}" multiple>
                                            </div>
                                        </div>
                                        <br/>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close
                                            </button>
                                            <button type="submit" class="btn btn-primary">Save changes</button>
                                        </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>

                @empty
                    <div class="col-xl-3 col-lg-4 col-md-6 col-sm-12">No items found</div>
                @endforelse

                    <div class="modal fade" id="createModal" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalCenterTitle">Create folder</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <i class="ti-close"></i>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="{{ route("dashboard.folders.store") }}" method="post" accept-charset="utf-8" enctype="multipart/form-data">
                                        @csrf
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="exampleFormControlSelect1">Department</label>
                                                    @if($departments->count())
                                                        <select class="form-control new_folder_deparment" name="department" required>
                                                            @foreach ($departments as $department)
                                                                <option value="{{ $department->id }}" data-dept-code="{{ $department->code }}" {{ (old("department") == $department->id ? "selected" : "") }}>{{ $department->name }}</option>
                                                            @endforeach
                                                            @else
                                                                <p>You haven't created any departments yet. <a class="text-primary" href="{{ route("dashboard.departments.create") }}">Create now.</a></p>
                                                            @endif
                                                        </select>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Archive ID</label>
                                                    <input type="text" name="arch_id" value="" class="form-control" placeholder="Archive ID" required>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Name</label>
                                                    <input type="text" name="name" value="{{ old('name') }}" minlength="2" maxlength="30" class="form-control" placeholder="Name" required>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Note</label>
                                                    <textarea class="form-control" name="note" maxlength="80">{{ old('note') }}</textarea>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <input type="file" class="form-control" id="file-item" name="file_item[]" accept="{{ $fileTypes }}" multiple>
                                            </div>
                                        </div>
                                        <br/>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close
                                            </button>
                                            <button type="submit" class="btn btn-primary">Save changes</button>
                                        </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>

            </div>
            @if(!Request::query('search'))
                {{$folders->appends($_GET)->links('layouts.pagination') }}
            @endif
        </div>

        @endsection

        @section('script')

            @yield('script')

@endsection
