<?php

namespace Database\Factories;

use App\Models\File;
use App\Models\Folder;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Facades\Storage;

class FileFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = File::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $folderId = $this->faker->numberBetween('1', '500');

        $folder = Folder::find($folderId);
        $name = $folder->name . ' - ' . $this->faker->unique()->date() . '.png';

        $location = $folder->location . DIRECTORY_SEPARATOR . $name;

        return [
            "folder_id" => $folderId,
            "name" => $name,
            "location" => $location,
            "created_at" => $this->faker->dateTime()
        ];
    }
}
