@extends('layouts.auth')

@section("title", "SaveSpace - Verify")

@section('content')

    <!-- logo -->
    <div id="logo">
        <img class="logo" src="{{ url('assets/media/images/logo.png') }}" alt="image">
    </div>
    <!-- ./ logo -->

    <h5>Verify your new e-mail address</h5>

    <!-- form -->
    <form action="{{ route("auth.verify", ["id" => $id, "token" => $token]) }}" method="post">
        @csrf
        @if ($errors->any())
            <div class="alert alert-danger">
                <ul class="m-0 pl-2">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <div class="form-group">
            <input type="text" class="form-control" name="security_code" autocomplete="off" placeholder="Security code" autofocus required>
        </div>
        <input type="submit" value="Verify" class="btn btn-primary btn-block">
        <hr>
        </form>
    <!-- ./ form -->

@endsection
