@extends('layouts.app')

@section("title", "SaveSpace - Users")

@section('head')
    <!-- Datatable -->
    <link rel="stylesheet" href="{{ url('vendors/dataTable/dataTables.min.css') }}" type="text/css">

@endsection

@section('content')

    <div class="page-header justify-content-between">
        <nav aria-label="breadcrumb" class="d-flex align-items-start">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="{{ url('/') }}">Dashboard</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Users</li>
            </ol>
        </nav>
        <div class="dropdown">
            <a href="javascript:void(0)" data-toggle="modal" data-target="#createModal" class="btn btn-primary text-white">
                Add user
            </a>
            <a href="{{ route('dashboard.users.export') }}" class="btn btn-success text-white">Export table</a>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="user-list" class="table table-lg">
                            <thead>
                            <tr>
                                <th></th>
                                <th>State</th>
                                <th>Username</th>
                                <th>Name</th>
                                <th>Created by</th>
                                <th>Created at</th>
                                <th>Updated at</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($users as $user)
                                <tr>
                                    <td></td>
                                    <td>
                                        @if($user->is_confirmed)
                                            @if ($user->is_active)
                                                <span class="badge bg-success-bright text-success">Active</span>
                                            @else
                                                <span class="badge bg-danger-bright text-danger">Blocked</span>
                                            @endif
                                        @else
                                            <span class="badge bg-warning-bright text-warning">New user</span>
                                        @endif
                                    </td>
                                    <td>
                                            @include('dashboard.partials.avatar')
                                        {{$user->username}}
                                    </td>
                                    <td>{{$user->name .' '. $user->surname}}
                                    <div class="font-weight-light p-1">{{$user->role->name}}</div>
                                    <div class="font-weight-light p-1">{{$user->email}}</div>
                                    <div class="font-weight-light p-1">{{$user->phone_number}}</div>
                                    </td>
                                    <td>{{ $user->getCreatedByName() }}</td>
                                    <td>{{ date('d.m.Y - H:i', strtotime($user->created_at)) }}</td>
                                    @if($user->updated_at==NULL)
                                        <td>/</td>
                                    @else
                                        <td>{{ date('d.m.Y - H:i', strtotime($user->updated_at)) }}</td>
                                    @endif
                                    <td>
                                        @if(Cache::has('is_online' . $user->id))
                                            <span data-toggle="tooltip" data-placement="bottom" title="{{ $user->last_seen }}" style="cursor: pointer;" class="text-success">Online</span>
                                        @else
                                            <span data-toggle="tooltip" data-placement="bottom" title="{{ $user->last_seen }}" class="text-secondary">Offline</span>
                                        @endif
                                    </td>
                                    @if($user->hasRole("Referent") && $user->is_confirmed)
                                        <td>
                                            <a href="javascript:void(0)" class="text-secondary" data-toggle="modal" data-target="#editModal_{{$user->id}}" title="Edit">
                                                <i class="ti-pencil"></i>
                                            </a>
                                            <a href="javascript:void(0)" class="text-danger ml-2" data-action="{{ route("dashboard.users.destroy", ["id" => $user->id]) }}" data-method="delete" title="Delete">
                                                <i class="ti-trash"></i>
                                            </a>
                                        </td>
                                    @else
                                        <td>/</td>
                                        @endif
                                </tr>

                                <div class="modal fade" id="editModal_{{$user->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalCenterTitle">Edit user</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <i class="ti-close"></i>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                <form action="{{ route("dashboard.users.edit", ["id" =>$user->id]) }}" method="post" accept-charset="utf-8" enctype='multipart/form-data'>
                                                    @method("patch")
                                                    @csrf
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label>Name</label>
                                                                <input type="text" name="name" value="{{ $user->name }}" minlength="2" maxlength="30" pattern="[a-zA-Zа-шА-Ш._\s]+" class="form-control" placeholder="Name" required>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label>Surname</label>
                                                                <input type="text" name="surname" value="{{$user->surname}}" minlength="2" maxlength="30" pattern="[a-zA-Zа-шА-Ш._\s]+" class="form-control" placeholder="Surname" required>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label class="form-label">Username</label>
                                                                <input type="text" name="username" value="{{ $user->username }}" minlength="5" maxlength="30" class="form-control" placeholder="Username" required>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label class="form-label">Role</label>

                                                                <select class="form-control" name="userRole" required>
                                                                    @foreach($roles as $role)
                                                                        <option value="{{ $role->id }}" {{ $user->role_id == $role->id ? "selected" : "" }}>{{ $role->name }}</option>
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label>Email</label>
                                                                <input type="email" name="email" value="{{ $user->email }}" maxlength="50" class="form-control" placeholder="E-mail" required>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label class="form-label">Phone Number</label>
                                                                <input type="text" name="phone_number" value="{{ $user->phone_number }}" class="form-control" placeholder="Phone number" autocomplete="off" required>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-md-5">
                                                            <div class="form-group">
                                                                <label>Avatar</label>
                                                                <input type="file" name="avatar" value="{{ $user->avatar }}" class="form-control" accept="image/*">
                                                            </div>
                                                        </div>
                                                        <div class="col-md-1">
                                                            <div class="form-group">
                                                                <label>Current</label>
                                                                @include('dashboard.partials.avatar')
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close
                                                        </button>
                                                        <button type="submit" class="btn btn-primary">Save changes</button>
                                                    </div>
                                                </form>
                                            </div>

                                        </div>
                                    </div>
                                </div>

                            @endforeach
                            </tbody>
                        </table>

                        <div class="modal fade" id="createModal" tabindex="-1" role="dialog" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="exampleModalCenterTitle">Create user</h5>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <i class="ti-close"></i>
                                        </button>
                                    </div>
                                    <div class="modal-body">
                                        <form action="{{ route("dashboard.users.store") }}" method="post" accept-charset="utf-8" enctype='multipart/form-data'>
                                            @csrf
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label>Name</label>
                                                        <input type="text" name="name" value="{{ old('name') }}" minlength="2" maxlength="25" pattern="[a-zA-Zа-шА-Ш._\s]+" class="form-control" placeholder="Name" required>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label>Surname</label>
                                                        <input type="text" name="surname" value="{{ old('surname') }}" minlength="2" maxlength="25" pattern="[a-zA-Zа-шА-Ш._\s]+" class="form-control" placeholder="Surname" required>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="form-label">Username</label>
                                                        <input type="text" name="username" value="{{ old('username') }}" minlength="5" maxlength="30" class="form-control" placeholder="Username" required>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="form-label">Role</label>
                                                        <select class="form-control" name="userRole" required>
                                                            @foreach ($roles as $role)
                                                                <option value="{{ $role->id }}" {{ (old("userRole") == $role->id ? "selected" : "" ) }}>{{ $role->name }}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label>Email</label>
                                                        <input type="email" name="email" value="{{ old('email') }}" class="form-control" placeholder="E-mail" required>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="form-label">Phone Number</label>
                                                        <input type="text" name="phone_number" value="{{ old('phone_number') }}" class="form-control" placeholder="Phone number" autocomplete="off" required>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label>Avatar</label>
                                                        <input type="file" name="avatar" value="{{ old('avatar') }}" class="form-control" accept="image/*">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close
                                                </button>
                                                <button type="submit" class="btn btn-primary">Save changes</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('script')
 <script src="{{ url('assets/js/examples/pages/user-list.js') }}"></script>
    <!-- Datatable -->
    <script src="{{ url('vendors/dataTable/dataTables.min.js') }}"></script>
@endsection
