<?php

namespace App\Exports;

use App\Models\Department;
use App\Models\User;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class DepartmentsExport implements FromCollection, WithMapping, WithHeadings
{
    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        return Department::all();
    }

    public function map($row): array{
        $fields = [
            $row->id,
            $row->name,
            $row->code,
            $row->no_of_folders,
            $row->user_id . ' - ' . User::find($row->user_id)->username,
            $row->created_at,
            $row->updated_at
        ];
        return $fields;
    }

    public function headings(): array
    {
        return [
            'ID',
            'Name',
            'Code',
            'Number of folders',
            'Created by ID - Username',
            'Created at',
            'Updated at',
        ];
    }
}
