<?php

namespace App\Exports;

use App\Models\Department;
use App\Models\Folder;
use App\Models\User;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class FoldersExport implements FromCollection, WithMapping, WithHeadings
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        return Folder::all();
    }

    public function map($row): array{
        $fields = [
            $row->id,
            $row->arch_id,
            $row->name,
            $row->note,
            $row->location,
            $row->user_id . ' - ' . User::find($row->user_id)->username,
            $row->Department::find($row->department_id)->name . ' - ' . Department::find($row->department_id)->code,
            $row->is_important,
            $row->created_at,
            $row->updated_at
        ];
        return $fields;
    }

    public function headings(): array
    {
        return [
            'ID',
            'Archive ID',
            'Name',
            'Note',
            'Location',
            'Created by ID - Username',
            'Department name - code',
            'Is important',
            'Created at',
            'Updated at'
        ];
    }
}
