<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;

class Department extends Model
{
    use Notifiable;
    use HasFactory;

    protected $table = "departments";

    protected $fillable = ["name", "code", "location", "user_id", "no_of_folders"];

    protected $casts = [
        'created_at' => 'datetime:d-m-Y',
    ];

    public function getCreatedByName()
    {
        return User::where('id', $this->user_id)->pluck('username')->first();
    }

    public function folder(){
        return $this->hasMany(Folder::class);
    }
}
