<?php

namespace App\Http\Controllers\Auth;

use App\Http\Requests\Auth\CreatePasswordRequest;
use App\Models\User;
use App\Http\Controllers\Controller;

class CreatePasswordController extends Controller
{
    public function __construct()
    {
        $this->middleware("createPassword");
    }

    public function showCreatePassword($id, $token)
    {
        return view("auth.create_password")->with([
            "id" => $id,
            "token" => $token
        ]);
    }

    public function createPassword(CreatePasswordRequest $request, $id, $token)
    {
        $user = User::find($id);

        $user->password = bcrypt($request->password);
        $user->is_active = true;
        $user->is_confirmed = true;

        if ($user->is_forgot_password) {
            $user->is_forgot_password = false;
        }

        $user->save();

        return redirect()->route("auth.loginShow");
    }
}
