<?php

namespace App\Http\Controllers\Auth;

use App\Http\Requests\Auth\VerifyNewEmailRequest;
use App\Models\User;
use App\Http\Controllers\Controller;

class VerifyNewEmailController extends Controller
{
    public function __construct()
    {
        $this->middleware("checkVerifyNewEmail");
    }

    public function create($id, $token)
    {
        return view("auth.verify")->with([
            "id" => $id,
            "token" => $token
        ]);
    }

    public function verify(VerifyNewEmailRequest $request, $id, $token)
    {
        $user = User::find($id);
        $user->is_active = true;
        $user->save();

        return redirect()->route("auth.login");
    }
}
