<?php

namespace App\Http\Middleware;

use Closure;
use App\Models\User;

class CheckVerifyNewEmail
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $id = $request->route("id");
        $token = $request->route("token");

        $user = User::findOrFail($id);

        if($user->is_active) {
            return redirect()->route("auth.loginShow");
        }

        return $next($request);
    }
}
