<?php

use Illuminate\Support\Str;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name');
            $table->string('surname');
            $table->string('username')->unique();
            $table->string('password');
            $table->string('email')->unique();
            $table->string('mobile_number')->unique();
            $table->integer('role_id')->unsigned();
            $table->foreign("role_id")->references("id")->on("roles");
            $table->boolean('is_active')->default(false);
            $table->boolean('is_online')->default(false);
            $table->boolean('is_confirmed')->default(false);
            $table->boolean('is_forgot_password')->default(false);
            $table->integer('security_code')->nullable();
            $table->string('verify_token')->nullable();
            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
