@extends('layouts.auth')

@section("title", "Create password | TechBlog")

@section('content')

    <!-- logo -->
    <div id="logo">
        <img class="logo" src="{{ url('assets/media/images/logo.png') }}" alt="image">
        <img class="logo-dark" src="{{ url('assets/media/images/logo-dark.png') }}" alt="image">
    </div>
    <!-- ./ logo -->

    <h5>Create password</h5>

    <!-- form -->
    <form action="{{ route("auth.create-password", ["id" => $id, "token" => $token]) }}" method="post">
        @csrf
        @if ($errors->any())
            <div class="alert alert-danger">
                <ul class="m-0 pl-2">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <div class="form-group">
            <input id="password" type="password" name="password" class="form-control" placeholder="Password" autocomplete="off" required autofocus>
        </div>
        <div class="form-group">
            <input id="password" type="password" name="password_confirmation" class="form-control" placeholder="Confirm password" autocomplete="off" required autofocus>
        </div>
        <div class="form-group">
            <input type="text" id="security_code" class="form-control" name="security_code" autocomplete="off" placeholder="Security code" required>
        </div>
        <input type="submit" value="Create Password" class="btn btn-primary btn-block">
        <hr>
     </form>
    <!-- ./ form -->

@endsection
