<?php

namespace App\Http\Controllers\Auth;

use App\Http\Requests\Auth\ForgotPasswordRequest;
use App\Models\User;
use App\Http\Controllers\Controller;
use App\Notifications\ForgotPassword;

class ForgotPasswordController extends Controller
{
    public function __construct()
    {
        $this->middleware("guest");
    }

    public function showForgotPassword()
    {
        return view("auth.forgot");
    }

    public function forgotPassword(ForgotPasswordRequest $request)
    {
        $user = User::where("email", $request->email)->first();

        $user->is_forgot_password = true;
        $user->is_active = false;
        $user->security_code = $user->generateSecurityCode();
        $user->verify_token = $user->generateVerifyToken();

        $user->save();

        $user->notify(new ForgotPassword($user));

        $request->session()->flash("forgotInfo", "We have sent an email to your inbox.");

        return redirect()->route("auth.forgotShow");
    }
}
