<?php

namespace App\Http\Middleware;

use Closure;

class CheckIsActive
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if(!auth()->user()->is_active) {

            $user = auth()->user();
            $user->is_online = false;
            $user->save();

            auth()->logout();

            return redirect()->route("auth.loginShow");
        }

        return $next($request);
    }
}
