<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

////////////////////
// Auth Routes
////////////////////
Route::prefix('auth')->group(function () {

    Route::get('/login', "Auth\LoginController@showLogin")->name("auth.loginShow");
    Route::post('/login', "Auth\LoginController@login")->name("auth.login");
    Route::post('/logout', "Auth\LoginController@logout")->name("auth.logout");

    Route::get('/forgot', "Auth\ForgotPasswordController@showForgotPassword")->name("auth.forgotShow");
    Route::post('/forgot', "Auth\ForgotPasswordController@forgotPassword")->name("auth.forgot");

    Route::group(['middleware' => "createPassword"], function () {
        Route::get('/create-password/{id}/{token}', "Auth\CreatePasswordController@showCreatePassword")->name("auth.create-password-show");
        Route::post('/create-password/{id}/{token}', "Auth\CreatePasswordController@createPassword")->name("auth.create-password");
    });

    Route::group(['middleware' => "checkVerifyNewEmail"], function () {
        Route::get('/verify/{id}/{token}', "Auth\VerifyNewEmailController@create")->name("auth.verifyShow");
        Route::post('/verify/{id}/{token}', "Auth\VerifyNewEmailController@verify")->name("auth.verify");
    });

});
