<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function() {
    return redirect()->route('dashboard.index');
});

Route::get('/offline', function () {
    return view('vendor/laravelpwa/offline');
});

////////////////////
// Auth Routes
////////////////////
Route::prefix('auth')->group(function () {

    Route::get('/login', "Auth\LoginController@showLogin")->name("auth.loginShow");
    Route::post('/login', "Auth\LoginController@login")->name("auth.login");
    Route::post('/logout', "Auth\LoginController@logout")->name("auth.logout");

    Route::get('/forgot', "Auth\ForgotPasswordController@showForgotPassword")->name("auth.forgotShow");
    Route::post('/forgot', "Auth\ForgotPasswordController@forgotPassword")->name("auth.forgot");

    Route::group(['middleware' => "createPassword"], function () {
        Route::get('/create-password/{id}/{token}', "Auth\CreatePasswordController@showCreatePassword")->name("auth.create-password-show");
        Route::post('/create-password/{id}/{token}', "Auth\CreatePasswordController@createPassword")->name("auth.create-password");
    });

    Route::group(['middleware' => "checkVerifyNewEmail"], function () {
        Route::get('/verify/{id}/{token}', "Auth\VerifyNewEmailController@create")->name("auth.verifyShow");
        Route::post('/verify/{id}/{token}', "Auth\VerifyNewEmailController@verify")->name("auth.verify");
    });

});

////////////////////
// Dashboard Routes
////////////////////
Route::group(['prefix' => 'dashboard', 'middleware' => ["auth", "checkIsActive"]], function () {

    Route::get("/", "Dashboard\IndexController@index")->name("dashboard.index");

    // Settings
    Route::get("/settings", "Dashboard\SettingsController@settings")->name("dashboard.settings.index");
    Route::patch("/settings/personal", "Dashboard\SettingsController@updatePersonalInformation")->name("dashboard.settings.personal");
    Route::patch("/settings/username", "Dashboard\SettingsController@updateUsername")->name("dashboard.settings.username");
    Route::patch("/settings/password", "Dashboard\SettingsController@updatePassword")->name("dashboard.settings.password");
    Route::patch("/settings/email", "Dashboard\SettingsController@updateEmail")->name("dashboard.settings.email");
    Route::patch("/settings/file-types", "Dashboard\SettingsController@fileTypes")->name("dashboard.settings.file-types");


    // Users
    Route::group(['middleware' => 'permission:manage_all_users'], function () {
        Route::get("/users", "Dashboard\UsersController@index")->name("dashboard.users.index");
        Route::patch("/users/{id}/block", "Dashboard\UsersController@block")->name("dashboard.users.block");
        Route::patch("/users/{id}/unblock", "Dashboard\UsersController@unblock")->name("dashboard.users.unblock");
        Route::delete("/users/{id}/destroy", "Dashboard\UsersController@destroy")->name("dashboard.users.destroy");
    });

        Route::group(['middleware' => 'permission:create_user'], function () {
        Route::get("/users/create", "Dashboard\UsersController@create")->name("dashboard.users.create");
        Route::post("/users/store", "Dashboard\UsersController@store")->name("dashboard.users.store");
        Route::get("/users/{id}/edit", "Dashboard\UsersController@editShow")->name("dashboard.users.editShow");
        Route::patch("/users/{id}/edit", "Dashboard\UsersController@edit")->name("dashboard.users.edit");
        Route::patch("/users/{id}/editUserData", "Dashboard\UsersController@editUserData")->name("dashboard.users.editUserData");
        Route::get('users/export', 'Dashboard\ExportExcelController@ExportUsers')->name("dashboard.users.export");
        });

    // Departments
    Route::group(['middleware' => 'permission:manage_all_departments'], function () {
        Route::get("/departments", "Dashboard\DepartmentsController@index")->name("dashboard.departments.index");
        Route::get("/departments/create", "Dashboard\DepartmentsController@create")->name("dashboard.departments.create");
        Route::post("/departments/store", "Dashboard\DepartmentsController@store")->name("dashboard.departments.store");
        Route::get("/departments/{id}/edit", "Dashboard\DepartmentsController@editShow")->name("dashboard.departments.editShow");
        Route::patch("/departments/{id}/edit", "Dashboard\DepartmentsController@edit")->name("dashboard.departments.edit");
        Route::delete("/departments/{id}/destroy", "Dashboard\DepartmentsController@destroy")->name("dashboard.departments.destroy");
        Route::get('/departments/download-all','Dashboard\DepartmentsController@downloadAll')->name('dashboard.departments.downloadAll');
        Route::get('/departments/{id}/download-department','Dashboard\DepartmentsController@downloadDepartment')->name('dashboard.departments.downloadDepartment');
        Route::get('departments/export', 'Dashboard\ExportExcelController@ExportDepartments')->name("dashboard.departments.export");
    });

    // Folders
    Route::get("/folders", "Dashboard\FoldersController@index")->name("dashboard.folders.index");
    Route::get("/folders/create", "Dashboard\FoldersController@create")->name("dashboard.folders.create");
    Route::post("/folders/store", "Dashboard\FoldersController@store")->name("dashboard.folders.store");
    Route::get("/folders/{id}/edit", "Dashboard\FoldersController@editShow")->name("dashboard.folders.editShow");
    Route::patch("/folders/{id}/edit", "Dashboard\FoldersController@edit")->name("dashboard.folders.edit");
    Route::patch("/folders/{id}/block", "Dashboard\FoldersController@block")->name("dashboard.folders.block");
    Route::patch("/folders/{id}/unblock", "Dashboard\FoldersController@unblock")->name("dashboard.folders.unblock");
    Route::patch("/folders/{id}/confirm", "Dashboard\FoldersController@confirm")->name("dashboard.folders.confirm");
    Route::delete("/folders/{id}/destroy", "Dashboard\FoldersController@destroy")->name("dashboard.folders.destroy");
    Route::patch('/folders/toggle-important/{id}', "Dashboard\FoldersController@toggleImportant")->name("dashboard.folders.toggleImportant");
    Route::get('/folders/{id}/download-folder','Dashboard\FoldersController@downloadFolder')->name('dashboard.folders.downloadFolder');
    Route::get('/folders/{id}/files','Dashboard\FoldersController@files')->name('dashboard.folders.files');
    Route::get('folders/export', 'Dashboard\ExportExcelController@ExportFolders')->name("dashboard.folders.export");

    // Files
    Route::get("files", "Dashboard\FilesController@index")->name("dashboard.files.index");
    Route::get("files/{id}/download-file", "Dashboard\FilesController@downloadFile")->name("dashboard.files.downloadFile");
    Route::patch("files/{id}/rename-file", "Dashboard\FilesController@renameFile")->name("dashboard.files.renameFile");
    Route::post("/files/store", "Dashboard\FilesController@store")->name("dashboard.files.store");
    Route::delete("files/{id}/delete-file", "Dashboard\FilesController@deleteFile")->name("dashboard.files.deleteFile");
    Route::get('files/export', 'Dashboard\ExportExcelController@ExportFiles')->name("dashboard.files.export");

});
