<?php

namespace App\Http\Requests\Dashboard;

use App\Models\Department;
use App\Models\FileType;
use App\Models\Folder;
use Illuminate\Foundation\Http\FormRequest;

class FolderRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        if ($this->isMethod("patch")) {
            $folder = Folder::find($this->route("id"));
            return auth()->user()->hasPermission("edit_all_folders") || ($folder->user->id == auth()->user()->id);
        }

        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules = [
            "arch_id" => [
                "required",
                "unique:folders,arch_id,$this->id,id",
                function ($attribute, $value, $fail) {

                    try {
                        $arch_id = $this->request->get('arch_id');

                        $deptCode = explode('/', $arch_id)[0];
                        $archNum = explode('/', $arch_id)[1];

                        if (empty($archNum)) {
                            $fail("Please enter folders Archive ID");
                        }

                        if ($deptCode != Department::find($this->request->get('department'))->code) {
                            $fail("Folder Archive ID field format is invalid");
                        }
                    }
                    catch (\Exception $e) {
                        $fail("Please enter folders Archive ID");
                    }
                }
            ],
            "name" => "required|min:2|max:30",
            "department" => "required|integer|exists:departments,id",
        ];

        $mimes = FileType::find("1")->mimes;
        $maxSize = FileType::find("1")->max_size;

        if ($this->isMethod("patch")) {
            $fileRules = [
                "file_item.*" => "mimes:{$mimes}|max:{$maxSize}"
            ];
        }

        else {
            $fileRules = [
                "file_item.*" => "mimes:{$mimes}|max:{$maxSize}"
            ];
        }

        $rules = array_merge(
            $rules,
            $fileRules,
        );

        return $rules;
    }
}
