<?php

namespace Database\Factories;

use App\Models\Department;
use App\Models\Folder;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Facades\Storage;
use function Sodium\increment;

class DepartmentFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Department::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $location = $this->faker->unique()->numberBetween(10, 25);
        Storage::disk('uploads')->makeDirectory('Departments/' . $location);
        return [
            'name' => "Department" . ' ' . $this->faker->unique()->firstName(),
            'code' => $location,
            'location' => 'Departments' . DIRECTORY_SEPARATOR . $location,
            'no_of_folders' => 0,
            'user_id' => "1",
            'created_at' => now()
        ];
    }
}
