<?php

namespace App\Services;

use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

class UploadService
{
    public function upload($object, $names, $fieldName = null, $isMultiple = false)
    {
        dd($object);
        $objIds = [];

        foreach ($names as $name => $item) {

            $property = $name;

            if ($fieldName) $property = $fieldName;

            if (!request()->hasFile($name)) {
                continue;
            }

            if (!$isMultiple) {
                if (!is_null($object->$property)) {
                    Storage::disk("image-uploads")->delete($object->$property);
                }
            }

            $images = request()->file($name);

            if(!is_array($images)) $images = [$images];

            foreach ($images as $image) {

                if($isMultiple) {
                    $object = new $object;
                }

                $extension = $image->getClientOriginalExtension();
                $fileName = Str::random(20) . time() . "." . $extension;


                Storage::disk("image-uploads")->put(
                    $fileName,
                    File::get($image)
                );

                $object->$property = $fileName;

                if ($fieldName) $object->save();
                array_push($objIds, $object->id);
            }
        }

        return $objIds;
    }
}
