<?php

namespace Database\Factories;

use App\Models\Department;
use App\Models\Document;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Facades\Storage;

class DocumentFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Document::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {

        $deptID = "1";
        $name = $this->faker->unique()->firstName();
        Storage::disk('local')->makeDirectory('Departments' . DIRECTORY_SEPARATOR . $deptID . DIRECTORY_SEPARATOR . $name);

        return [
            'arch_id' => $deptID . "/" . $this->faker->unique()->randomNumber(),
            'name' => $name,
            'description' => $this->faker->realText(),
            'user_id' => $this->faker->numberBetween('1', '2'),
            'department_id' => $deptID,
            'is_important' => $this->faker->boolean,
            'created_at' => $this->faker->dateTime()
        ];

    }
}
