@extends('layouts.app')

@section("title", "User Settings")

@section('pageTitle', 'User Settings')

@section('content')

    <div class="page-header">
        <nav aria-label="breadcrumb" class="d-flex align-items-start">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="{{ url('dashboard/users') }}">Users</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">User Settings</li>
            </ol>
        </nav>
    </div>

    <div class="row">
        <div class="col-md-12">

            <div class="row">
                <div class="col-lg-3 col-md-12 mb-3">
                    <div class="nav flex-lg-column flex-sm-row nav-pills" id="v-pills-tab" role="tablist" aria-orientation="vertical">
                        <a class="nav-link {{ $active_tab == 'account' ? 'active' : '' }}" id="account-tab" data-toggle="pill" href="#account" role="tab" aria-controls="account" aria-selected="true">Account</a>
                        <a class="nav-link {{ $active_tab == 'security' ? 'active' : '' }}" id="security-tab" data-toggle="pill" href="#security" role="tab" aria-controls="security" aria-selected="false">Security</a>
                        <a class="nav-link " id="v-pills-settings-tab" data-toggle="pill" href="#v-pills-settings" role="tab" aria-controls="v-pills-settings" aria-selected="false">Social</a>
                    </div>
                </div>
                <div class="col-lg-9 col-md-12">
                    <div class="tab-content" id="v-pills-tabContent">
                        <div class="tab-pane fade show {{ $active_tab == 'account' ? 'active' : '' }}" id="account" role="tabpanel" aria-labelledby="account-tab">
                            <div class="card">
                                <div class="card-body">
                                    <h6 class="card-title">Account</h6>
                                    <form action="{{ route("dashboard.users.editUserData", ["id" =>$user->id]) }}" method="post" accept-charset="utf-8" enctype='multipart/form-data' class="needs-validation" novalidate>
                                        @method("patch")
                                        @csrf
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Name</label>
                                                    <input type="text" name="name" value="{{ $user->name }}" minlength="2" maxlength="30" class="form-control" placeholder="Name" required>
                                                    <div class="invalid-feedback">
                                                        Please enter only letters and spaces with length between [2, 30]
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Surname</label>
                                                    <input type="text" name="surname" value="{{$user->surname}}" class="form-control" placeholder="Surname" required>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label class="form-label">Mobile Number</label>
                                                    <input type="text" name="phone_number" value="{{ $user->phone_number }}" class="form-control" placeholder="Phone number" autocomplete="off" required>
                                                </div>
                                            </div>
                                            <div class="col-md-5">
                                                <div class="form-group">
                                                    <label>Avatar</label>
                                                    <input type="file" name="avatar" value="{{ $user->avatar }}" class="form-control" accept="image/*">
                                                </div>
                                            </div>
                                        <div class="col-md-1">
                                            <div class="form-group">
                                                <label>Current</label>
                                                @include('dashboard.partials.avatar')
                                            </div>
                                        </div>
                                        </div>
                                        <input type="submit" value="Save changes" class="submitBtn btn btn-primary pull-right m-10">
                                    </form>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane {{ $active_tab == 'security' ? 'active' : '' }}" id="security" role="tabpanel" aria-labelledby="security-tab">
                            <div class="card">
                                <div class="card-body">
                                    <form class="actionForm" action="{{ route("dashboard.settings.password") }}"
                                          method="post" accept-charset="UTF-8">

                                        @method("patch")
                                        @csrf

                                        <fieldset class="form-fieldset">

                                            <h4 class="font-weight-normal border-bottom pb-2">Password</h4>

                                            <h6 class="font-weight-normal text-muted">After changing your
                                                password you will be logged out automatically.</h6>

                                            <div class="row">

                                                <div class="col-md-4">
                                                    <div class="form-group">
                                                        <label class="form-label">Current Password <span
                                                                class="form-required">*</span></label>
                                                        <input type="password" class="form-control"
                                                               name="current_password" autocomplete="off"
                                                               required>
                                                    </div>
                                                </div>

                                                <div class="col-md-4">
                                                    <div class="form-group">
                                                        <label class="form-label">New Password <span
                                                                class="form-required">*</span></label>
                                                        <input type="password" class="form-control"
                                                               name="password" autocomplete="off" required>
                                                    </div>
                                                </div>

                                                <div class="col-md-4">
                                                    <div class="form-group">
                                                        <label class="form-label">Repeat New Password <span
                                                                class="form-required">*</span></label>
                                                        <input type="password" class="form-control"
                                                               name="password_confirmation" autocomplete="off"
                                                               required>
                                                    </div>
                                                </div>

                                                <div class="col-md-12">
                                                    <div class="form-group mb-0 float-right">
                                                        <input type="submit" value="Submit"
                                                               class="submitBtn btn btn-primary">
                                                    </div>
                                                </div>

                                            </div>

                                        </fieldset>

                                    </form>
                                </div>
                            </div>


                            <div class="card">
                                <div class="card-body">
                                    <form class="actionForm" action="{{ route("dashboard.settings.username") }}"
                                          method="post" accept-charset="UTF-8">

                                        @method("patch")
                                        @csrf

                                        <fieldset class="form-fieldset">

                                            <h4 class="font-weight-normal border-bottom pb-2">Username</h4>

                                            <h6 class="font-weight-normal text-muted">After changing your
                                                username you will be logged out automatically.</h6>

                                            <div class="row">


                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="form-label">Username</label>
                                                        <input type="text"
                                                               value="{{ old("username", $user->username) }}"
                                                               name="username" class="form-control">
                                                    </div>
                                                </div>

                                                <div class="col-md-12">
                                                    <div class="form-group mb-0 float-right">
                                                        <input type="submit" value="Submit"
                                                               class="submitBtn btn btn-primary">
                                                    </div>
                                                </div>

                                            </div>

                                        </fieldset>

                                    </form>

                                </div>
                    </div>

                            <div class="card">
                                <div class="card-body">
                                    <form class="actionForm" action="{{ route("dashboard.settings.email") }}"
                                          method="post" accept-charset="UTF-8">

                                        @method("patch")
                                        @csrf

                                        <fieldset class="form-fieldset">

                                            <h4 class="font-weight-normal border-bottom pb-2">E-mail</h4>

                                            <h6 class="font-weight-normal text-muted">This is where lost
                                                password requests will be sent. After changing your e-mail you
                                                will be logged out automatically.</h6>

                                            <div class="row">

                                                <div class="col-md-4">
                                                    <div class="form-group">
                                                        <label class="form-label">E-mail</label>
                                                        <input type="email"
                                                               value="{{ old("email", $user->email) }}"
                                                               name="email" class="form-control">
                                                    </div>
                                                </div>

                                                <div class="col-md-12">
                                                    <div class="form-group mb-0 float-right">
                                                        <input type="submit" value="Submit"
                                                               class="submitBtn btn btn-primary">
                                                    </div>
                                                </div>

                                            </div>

                                        </fieldset>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane fade" id="v-pills-settings" role="tabpanel" aria-labelledby="v-pills-settings-tab">
                            <div class="card">
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

@endsection
