<?php

namespace App\Http\Controllers\Dashboard;

use App\Exports\FilesExport;
use App\Exports\FoldersExport;
use App\Exports\UsersExport;
use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Facades\Excel;


class ExportExcelController extends Controller
{
    public function ExportUsers()
    {
        return Excel::download(new UsersExport(), Carbon::now()->format('d.m.Y - H:i') . ' - users.xlsx');

    }

    public function ExportFolders()
    {
        return Excel::download(new FoldersExport(), Carbon::now()->format('d.m.Y - H:i') . ' - folders.xlsx');

    }

    public function ExportFiles()
    {
        return Excel::download(new FilesExport(), Carbon::now()->format('d.m.Y - H:i') . ' - files.xlsx');

    }
}
