<?php

namespace App\Http\Requests\Dashboard;

use App\Helpers\Alert;
use App\Models\FileType;
use App\Rules\UploadCount;
use Illuminate\Foundation\Http\FormRequest;

class FileRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules = [
            "folder" => "required|integer|exists:folders,id",
            ];

        $mimes = FileType::find("1")->mimes;
        $maxSize = FileType::find("1")->max_size;

        if ($this->isMethod("patch")) {
            $fileRules = [
                "file_item.*" => "mimes:{$mimes}|max:{$maxSize}"
            ];
        }

        else {
            $fileRules = [
                "file_item.*" => "mimes:{$mimes}|max:{$maxSize}"
            ];
        }

        $rules = array_merge(
            $rules,
            $fileRules,
        );

        return $rules;
    }
}
