<?php

namespace App\Http\Requests\Dashboard;

use Illuminate\Foundation\Http\FormRequest;

class UpdateUserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            "name" => "required|alpha|min:2|max:30",
            "surname" => "required|alpha|min:2|max:30",
            "phone_number" => "required|unique:users,phone_number,$this->id,id",
            "email" => "required|string|email|max:50|unique:users,email,$this->id,id",
            "username" => "required|alpha_dash|min:5|unique:users,username,$this->id,id",
            "userRole" => "required|exists:roles,id",
            "avatar" => "mimes:jpeg,png,gif|max:5000",
        ];
    }

    protected function getValidatorInstance()
    {

        return parent::getValidatorInstance();
    }
}
