<?php

namespace Database\Factories;

use App\Models\Department;
use App\Models\Folder;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Facades\Storage;

class FolderFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Folder::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {

        $deptId = $this->faker->numberBetween('1', '15');
        $deptCode = Department::find($deptId)->code;
        $name = $this->faker->unique()->firstName();

        $location = 'Departments' . DIRECTORY_SEPARATOR . $deptCode . DIRECTORY_SEPARATOR . $name;
        Storage::disk('uploads')->makeDirectory($location);


        return [
            'arch_id' => $deptCode . "/" . $this->faker->unique()->randomNumber(),
            'name' => $name,
            'note' => $this->faker->realText(),
            'location' => $location,
            'user_id' => $this->faker->numberBetween('1', '2'),
            'department_id' => $deptId,
            'is_important' => $this->faker->boolean,
            'created_at' => $this->faker->dateTime()
        ];
    }
}
